package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class Polygon extends VectorElement
{
	protected double[][] data;
	protected int[][] sdata;
	protected ArrayData pdata;
	protected int count;
	
	public Polygon()
	{
		pdata = new ArrayData();
		pdata.type = ArrayData.HARMONIC;
		
		count = 3;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		pdata = new ArrayData(dis);
		count = dis.readUnsignedShort();
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		pdata.write(dos);
		dos.writeShort(count);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		data = AuxMath.plotPolygon(pdata.vala, pdata.valb, pdata.diva, pdata.divb, count, pdata.inta, pdata.intb);
		sdata = new int[data.length][2];
	}
	
	public void rescale()
	{
		for(int i = 0; i < data.length; i++)
		{
			sdata[i][0] = getScaled(data[i][0], 0);
			sdata[i][1] = getScaled(data[i][1], 1);
		}
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(group.image.usecolor)
		{
			g.setColor(color);
		}
		
		int i;
		
		if(fill)
		{
			for(i = 2; i < data.length; i++)
			{
				g.fillTriangle(sdata[0][0], sdata[0][1], sdata[i][0], sdata[i][1], sdata[i - 1][0], sdata[i - 1][1]);
			}
		}
		else
		{
			g.setStrokeStyle(stroke);
			
			for(i = 1; i < data.length; i++)
			{
				g.drawLine(sdata[i][0], sdata[i][1], sdata[i - 1][0], sdata[i - 1][1]);
			}
			
			i--;
			
			g.drawLine(sdata[0][0], sdata[0][1], sdata[i][0], sdata[i][1]);
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						break;
					
					case X:
						pdata.vala = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case Y:
						pdata.valb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case WIDTH:
						pdata.diva = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case HEIGHT:
						pdata.divb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case ROTATION:
						pdata.inta = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case ANGLE:
						pdata.intb = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
						changed = true;
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		switch(param)
		{
			case X:
				return new Double(pdata.vala);
			
			case Y:
				return new Double(pdata.valb);
			
			case WIDTH:
				return new Double(pdata.diva);
			
			case HEIGHT:
				return new Double(pdata.divb);
			
			case ROTATION:
				return new Integer(pdata.inta);
			
			case ANGLE:
				return new Integer(pdata.intb);
			
			case POLY_COUNT:
				return new Integer(count);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		switch(param)
		{
			case X:
				pdata.vala = ((Double)value).doubleValue();
				break;
			
			case Y:
				pdata.valb = ((Double)value).doubleValue();
				break;
			
			case WIDTH:
				pdata.diva = ((Double)value).doubleValue();
				break;
			
			case HEIGHT:
				pdata.divb = ((Double)value).doubleValue();
				break;
			
			case ROTATION:
				pdata.inta = ((Integer)value).intValue();
				break;
			
			case ANGLE:
				pdata.intb = ((Integer)value).intValue();
				break;
			
			case POLY_COUNT:
				count = ((Integer)value).intValue();
				break;
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<polygon");
		
		ps.print(" points=\"");
		ps.print(Integer.toString(sdata[0][0]) + " " + Integer.toString(sdata[0][1]));
		
		for(int i = 1; i < sdata.length; i++)
		{
			ps.print(", " + Integer.toString(sdata[i][0]) + " " + Integer.toString(sdata[i][1]));
		}
		
		ps.print("\"");
		
		writeSVGTail(ps, true, true);
		
		ps.println("/>");
	}
}