package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class Polyline extends VectorElement
{
	protected double[][] data;
	protected int[][] sdata;
	
	public Polyline()
	{
		data = new double[3][2];
		data[0][0] = 0;
		data[0][1] = 0;
		data[1][0] = 0;
		data[1][1] = 0;
		data[2][0] = 0;
		data[2][1] = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		data = new double[dis.readUnsignedShort()][2];
		
		for(int i = 0; i < data.length; i++)
		{
			data[i][0] = dis.readFloat();
			data[i][1] = dis.readFloat();
		}
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeShort(data.length);
		
		for(int i = 0; i < data.length; i++)
		{
			dos.writeFloat((float)data[i][0]);
			dos.writeFloat((float)data[i][1]);
		}
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		sdata = new int[data.length][2];
	}
	
	public void rescale()
	{
		for(int i = 0; i < data.length; i++)
		{
			sdata[i][0] = getScaled(data[i][0], 0);
			sdata[i][1] = getScaled(data[i][1], 1);
		}
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(group.image.usecolor)
		{
			g.setColor(color);
		}
		
		g.setStrokeStyle(stroke);
		
		for(int i = 1; i < sdata.length; i++)
		{
			g.drawLine(sdata[i][0], sdata[i][1], sdata[i - 1][0], sdata[i - 1][1]);
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				if(param == SHOW)
				{
					setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
				}
				else if(param == COLOR)
				{
					color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
				}
				else
				{
					subparam = transform.getSubParam() - 1;
					
					if(subparam >= 0 && subparam < data.length)
					{
						switch(param)
						{
							case X:
								data[subparam][0] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case Y:
								data[subparam][1] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
					}
				}
			}
		}
		
		if(flag && changed)
		{
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		if(param == COUNT)
		{
			return new Integer(data.length);
		}
		else if(param == X)
		{
			subparam--;
			
			if(subparam >= 0 && subparam < data.length)
			{
				return new Double(data[subparam][0]);
			}
		}
		else if(param == Y)
		{
			subparam--;
			
			if(subparam >= 0 && subparam < data.length)
			{
				return new Double(data[subparam][1]);
			}
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		if(param == COUNT)
		{
			double[][] p = new double[((Integer)value).intValue()][2];
			int minlength = Math.min(data.length, p.length);
			
			for(int i = 0; i < minlength; i++)
			{
				p[i][0] = data[i][0];
				p[i][1] = data[i][1];
			}
			
			data = p;
		}
		else if(param == X)
		{
			subparam--;
			
			if(subparam >= 0 && subparam < data.length)
			{
				data[subparam][0] = ((Double)value).doubleValue();
			}
		}
		else if(param == Y)
		{
			subparam--;
			
			if(subparam >= 0 && subparam < data.length)
			{
				data[subparam][1] = ((Double)value).doubleValue();
			}
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<polyline");
		
		ps.print(" points=\"");
		ps.print(Integer.toString(sdata[0][0]) + " " + Integer.toString(sdata[0][1]));
		
		for(int i = 1; i < sdata.length; i++)
		{
			ps.print(", " + Integer.toString(sdata[i][0]) + " " + Integer.toString(sdata[i][1]));
		}
		
		ps.print("\"");
		
		writeSVGTail(ps, true, false);
		
		ps.println("/>");
	}
}