package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class RoundRect extends VectorElement
{
	protected double[] data = new double[6];
	protected int[] sdata = new int[6];
	
	public RoundRect()
	{
		data[0] = 0;
		data[1] = 0;
		data[2] = 0;
		data[3] = 0;
		data[4] = 0;
		data[5] = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		data[0] = dis.readFloat();
		data[1] = dis.readFloat();
		data[2] = dis.readFloat();
		data[3] = dis.readFloat();
		data[4] = dis.readFloat();
		data[5] = dis.readFloat();
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeFloat((float)data[0]);
		dos.writeFloat((float)data[1]);
		dos.writeFloat((float)data[2]);
		dos.writeFloat((float)data[3]);
		dos.writeFloat((float)data[4]);
		dos.writeFloat((float)data[5]);
		
		writeTransformList(dos);
	}
	
	public void rescale()
	{
		sdata[0] = getScaled(data[0], 0);
		sdata[1] = getScaled(data[1], 1);
		sdata[2] = getScaled(data[2], 2);
		sdata[3] = getScaled(data[3], 3);
		sdata[4] = getScaled(data[4], 2);
		sdata[5] = getScaled(data[5], 3);
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(group.image.usecolor)
		{
			g.setColor(color);
		}
		
		if(fill)
		{
			g.fillRoundRect(sdata[0], sdata[1], sdata[2], sdata[3], sdata[4], sdata[5]);
		}
		else
		{
			g.setStrokeStyle(stroke);
			g.drawRoundRect(sdata[0], sdata[1], sdata[2], sdata[3], sdata[4], sdata[5]);
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						break;
					
					case X:
						data[0] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case Y:
						data[1] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case WIDTH:
						data[2] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case HEIGHT:
						data[3] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case ARC_WIDTH:
						data[4] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case ARC_HEIGHT:
						data[5] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		switch(param)
		{
			case X:
				return new Double(data[0]);
			
			case Y:
				return new Double(data[1]);
			
			case WIDTH:
				return new Double(data[2]);
			
			case HEIGHT:
				return new Double(data[3]);
			
			case ARC_WIDTH:
				return new Double(data[4]);
			
			case ARC_HEIGHT:
				return new Double(data[5]);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		switch(param)
		{
			case X:
				data[0] = ((Double)value).doubleValue();
				break;
			
			case Y:
				data[1] = ((Double)value).doubleValue();
				break;
			
			case WIDTH:
				data[2] = ((Double)value).doubleValue();
				break;
			
			case HEIGHT:
				data[3] = ((Double)value).doubleValue();
				break;
			
			case ARC_WIDTH:
				data[4] = ((Double)value).doubleValue();
				break;
			
			case ARC_HEIGHT:
				data[5] = ((Double)value).doubleValue();
				break;
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<rect");
		
		ps.print(" x=\"" + Integer.toString(sdata[0]) + "\"");
		ps.print(" y=\"" + Integer.toString(sdata[1]) + "\"");
		ps.print(" width=\"" + Integer.toString(sdata[2]) + "\"");
		ps.print(" height=\"" + Integer.toString(sdata[3]) + "\"");
		ps.print(" rx=\"" + Integer.toString(sdata[4] / 2) + "\"");
		ps.print(" ry=\"" + Integer.toString(sdata[5] / 2) + "\"");
		
		writeSVGTail(ps, true, true);
		
		ps.println("/>");
	}
}