package com.one.vector;

import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import java.io.*;

public class TextureRoundRect extends VectorElement
{
	protected double[] data = new double[6];
	protected int[] sdata = new int[6];
	
	protected String filename;
	protected int[] texdata;
	protected int texwidth, texheight;
	
	protected int[] imagedata;
	protected int scanlength;
	
	protected boolean ready = false;
	
	public TextureRoundRect()
	{
		data[0] = 0;
		data[1] = 0;
		data[2] = 0;
		data[3] = 0;
		data[4] = 0;
		data[5] = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		data[0] = dis.readFloat();
		data[1] = dis.readFloat();
		data[2] = dis.readFloat();
		data[3] = dis.readFloat();
		data[4] = dis.readFloat();
		data[5] = dis.readFloat();
		
		System.gc();
		
		try
		{
			if(dis.readBoolean())
			{
				int blen = dis.readInt();
				byte[] b = new byte[blen];
				
				dis.readFully(b);
				Image texture = Image.createImage(b, 0, blen);
				b = null;
				
				texwidth = texture.getWidth();
				texheight = texture.getHeight();
				
				System.gc();
				texdata = new int[texwidth * texheight];
				texture.getRGB(texdata, 0, texwidth, 0, 0, texwidth, texheight);
			}
			else
			{
				texwidth = dis.readInt();
				texheight = dis.readInt();
				
				texdata = new int[texwidth * texheight];
				
				for(int i = 0; i < texdata.length; i++)
				{
					texdata[i] = dis.readInt();
				}
			}
		}
		catch(OutOfMemoryError oome)
		{
			texwidth = Bitmap.DEFTEX_WIDTH;
			texheight = Bitmap.DEFTEX_HEIGHT;
			
			texdata = new int[texwidth * texheight];
			
			for(int i = 0; i < texdata.length; i++)
			{
				texdata[i] = color;
			}
		}
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.write(getFlag());
		
		dos.writeFloat((float)data[0]);
		dos.writeFloat((float)data[1]);
		dos.writeFloat((float)data[2]);
		dos.writeFloat((float)data[3]);
		dos.writeFloat((float)data[4]);
		dos.writeFloat((float)data[5]);
		
		try
		{
			InputStream is = Connector.openInputStream("file:///" + filename);
			
			byte[] b = new byte[4096];
			
			dos.writeBoolean(true);
			dos.writeInt(is.available());
			
			while(is.available() > 0)
			{
				dos.write(b, 0, is.read(b));
			}
			
			is.close();
		}
		catch(Exception e)
		{
			dos.writeBoolean(false);
			dos.writeInt(texwidth);
			dos.writeInt(texheight);
			
			for(int i = 0; i < texdata.length; i++)
			{
				dos.writeInt(texdata[i]);
			}
		}
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		if(texdata == null)
		{
			try
			{
				InputStream is = Connector.openInputStream("file:///" + filename);
				Image texture = Image.createImage(is);
				is.close();
				
				System.gc();
				
				texwidth = texture.getWidth();
				texheight = texture.getHeight();
				
				texdata = new int[texwidth * texheight];
				texture.getRGB(texdata, 0, texwidth, 0, 0, texwidth, texheight);
			}
			catch(Throwable t)
			{
				texwidth = Bitmap.DEFTEX_WIDTH;
				texheight = Bitmap.DEFTEX_HEIGHT;
				
				texdata = new int[texwidth * texheight];
				
				for(int i = 0; i < texdata.length; i++)
				{
					texdata[i] = color;
				}
			}
		}
	}
	
	public void rescale()
	{
		sdata[0] = getScaled(data[0], 0);
		sdata[1] = getScaled(data[1], 1);
		sdata[2] = getScaled(data[2], 2);
		sdata[3] = getScaled(data[3], 3);
		sdata[4] = getScaled(data[4], 2);
		sdata[5] = getScaled(data[5], 3);
		
		ready = false;
		
		try
		{
			int repx = (sdata[2] + texwidth - 1) / texwidth;
			int repy = (sdata[3] + texheight - 1) / texheight;
			
			scanlength = texwidth * repx;
			
			System.gc();
			imagedata = new int[scanlength * texheight * repy];
			
			int i, j, k;
			
			for(i = 0; i < repx; i++)
			{
				for(j = 0; j < repy; j++)
				{
					for(k = 0; k < texheight; k++)
					{
						System.arraycopy(texdata, texwidth * k, imagedata, texwidth * i + (texheight * j + k) * scanlength, texwidth);
					}
				}
			}
			
			Image temp = Image.createImage(sdata[2], sdata[3]);
			Graphics g = temp.getGraphics();
			
			g.setColor(0);
			g.fillRect(0, 0, sdata[2], sdata[3]);
			g.setColor(0xFFFFFFFF);
			g.fillRoundRect(0, 0, sdata[2], sdata[3], sdata[4], sdata[5]);
			
			System.gc();
			int[] shapedata = new int[imagedata.length];
			temp.getRGB(shapedata, 0, scanlength, 0, 0, sdata[2], sdata[3]);
			
			for(i = 0; i < shapedata.length; i++)
			{
				if((shapedata[i] & 0xFFFFFF) == 0)
				{
					imagedata[i] = 0;
				}
			}
			
			ready = true;
		}
		catch(Throwable t)
		{
		}
		
		System.gc();
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(ready && group.image.usecolor)
		{
			g.drawRGB(imagedata, 0, scanlength, sdata[0], sdata[1], sdata[2], sdata[3], true);
		}
		else
		{
			if(group.image.usecolor)
			{
				g.setColor(color);
			}
			
			g.fillRoundRect(sdata[0], sdata[1], sdata[2], sdata[3], sdata[4], sdata[5]);
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						break;
					
					case X:
						data[0] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case Y:
						data[1] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case WIDTH:
						data[2] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case HEIGHT:
						data[3] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case ARC_WIDTH:
						data[4] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						break;
					
					case ARC_HEIGHT:
						data[5] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		switch(param)
		{
			case X:
				return new Double(data[0]);
			
			case Y:
				return new Double(data[1]);
			
			case WIDTH:
				return new Double(data[2]);
			
			case HEIGHT:
				return new Double(data[3]);
			
			case ARC_WIDTH:
				return new Double(data[4]);
			
			case ARC_HEIGHT:
				return new Double(data[5]);
			
			case FILE:
				return filename;
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		switch(param)
		{
			case X:
				data[0] = ((Double)value).doubleValue();
				break;
			
			case Y:
				data[1] = ((Double)value).doubleValue();
				break;
			
			case WIDTH:
				data[2] = ((Double)value).doubleValue();
				break;
			
			case HEIGHT:
				data[3] = ((Double)value).doubleValue();
				break;
			
			case ARC_WIDTH:
				data[4] = ((Double)value).doubleValue();
				break;
			
			case ARC_HEIGHT:
				data[5] = ((Double)value).doubleValue();
				break;
			
			case FILE:
				filename = (String)value;
				texdata = null;
				break;
		}
	}
}