package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class ThickLine extends VectorElement
{
	protected double[] data;
	protected int[] sdata;
	protected double x1, y1, x2, y2, thickness;
	
	public ThickLine()
	{
		x1 = 0;
		y1 = 0;
		x2 = 0;
		y2 = 0;
		
		thickness = 0;
	}
	
	public ThickLine(int color, int flag, double x1, double y1, double x2, double y2, double thickness)
	{
		this.color = color;
		this.x1 = x1;
		this.y1 = y1;
		this.x2 = x2;
		this.y2 = y2;
		this.thickness = thickness;
		parseFlag(flag);
		
		create();
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		x1 = dis.readFloat();
		y1 = dis.readFloat();
		x2 = dis.readFloat();
		y2 = dis.readFloat();
		thickness = dis.readFloat();
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeFloat((float)x1);
		dos.writeFloat((float)y1);
		dos.writeFloat((float)x2);
		dos.writeFloat((float)y2);
		dos.writeFloat((float)thickness);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		data = AuxMath.plotThickLine(x1, y1, x2, y2, thickness, true);
		sdata = new int[data.length];
	}
	
	public void rescale()
	{
		sdata[0] = getScaled(data[0], 0);
		sdata[1] = getScaled(data[1], 1);
		sdata[2] = getScaled(data[2], 0);
		sdata[3] = getScaled(data[3], 1);
		sdata[4] = getScaled(data[4], 0);
		sdata[5] = getScaled(data[5], 1);
		sdata[6] = getScaled(data[6], 0);
		sdata[7] = getScaled(data[7], 1);
		
		sdata[8] = getScaled(data[8], 0);
		sdata[9] = getScaled(data[9], 1);
		sdata[10] = getScaled(data[10], 0);
		sdata[11] = getScaled(data[11], 1);
		sdata[12] = getScaled(data[12], 2);
		sdata[13] = getScaled(data[13], 3);
		
		sdata[8] -= sdata[12];
		sdata[9] -= sdata[13];
		sdata[10] -= sdata[12];
		sdata[11] -= sdata[13];
		sdata[12] *= 2;
		sdata[13] *= 2;
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(group.image.usecolor)
		{
			g.setColor(color);
		}
		
		g.fillTriangle(sdata[0], sdata[1], sdata[2], sdata[3], sdata[4], sdata[5]);
		g.fillTriangle(sdata[2], sdata[3], sdata[4], sdata[5], sdata[6], sdata[7]);
		
		g.fillArc(sdata[8], sdata[9], sdata[12], sdata[13], 0, 360);
		g.fillArc(sdata[10], sdata[11], sdata[12], sdata[13], 0, 360);
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				subparam = transform.getSubParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						break;
					
					case X:
						switch(subparam)
						{
							case 1:
								x1 = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 2:
								x2 = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
						break;
					
					case Y:
						switch(subparam)
						{
							case 1:
								y1 = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 2:
								y2 = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
						break;
					
					case THICKNESS:
						thickness = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		if(param == X)
		{
			if(subparam == 1)
			{
				return new Double(x1);
			}
			else if(subparam == 2)
			{
				return new Double(x2);
			}
		}
		else if(param == Y)
		{
			if(subparam == 1)
			{
				return new Double(y1);
			}
			else if(subparam == 2)
			{
				return new Double(y2);
			}
		}
		else if(param == THICKNESS)
		{
			return new Double(thickness);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		if(param == X)
		{
			if(subparam == 1)
			{
				x1 = ((Double)value).doubleValue();
			}
			else if(subparam == 2)
			{
				x2 = ((Double)value).doubleValue();
			}
		}
		else if(param == Y)
		{
			if(subparam == 1)
			{
				y1 = ((Double)value).doubleValue();
			}
			else if(subparam == 2)
			{
				y2 = ((Double)value).doubleValue();
			}
		}
		else if(param == THICKNESS)
		{
			thickness = ((Double)value).doubleValue();
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<line");
		
		ps.print(" x1=\"" + Integer.toString(getScaled(x1, 0)) + "\"");
		ps.print(" y1=\"" + Integer.toString(getScaled(y1, 1)) + "\"");
		ps.print(" x2=\"" + Integer.toString(getScaled(x2, 0)) + "\"");
		ps.print(" y2=\"" + Integer.toString(getScaled(y2, 1)) + "\"");
		
		ps.print(" stroke-width=\"" + Integer.toString(getScaled(thickness, 4)) + "\"");
		ps.print(" stroke-linecap=\"round\"");
		
		writeSVGTail(ps, false, false);
		
		ps.println("/>");
	}
}