package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class ThickPolyline extends VectorElement
{
	protected ThickLine[] lines;
	protected double[][] data;
	protected double thickness;
	
	public ThickPolyline()
	{
		data = new double[3][2];
		data[0][0] = 0;
		data[0][1] = 0;
		data[1][0] = 0;
		data[1][1] = 0;
		data[2][0] = 0;
		data[2][1] = 0;
		
		thickness = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		data = new double[dis.readUnsignedShort()][2];
		
		for(int i = 0; i < data.length; i++)
		{
			data[i][0] = dis.readFloat();
			data[i][1] = dis.readFloat();
		}
		
		thickness = dis.readFloat();
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeShort(data.length);
		
		for(int i = 0; i < data.length; i++)
		{
			dos.writeFloat((float)data[i][0]);
			dos.writeFloat((float)data[i][1]);
		}
		
		dos.writeFloat((float)thickness);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		lines = new ThickLine[data.length - 1];
		
		for(int i = 0; i < lines.length; i++)
		{
			lines[i] = new ThickLine(color, NORMAL, data[i][0], data[i][1], data[i + 1][0], data[i + 1][1], thickness);
			lines[i].setGroup(group);
		}
	}
	
	public void rescale()
	{
		for(int i = 0; i < lines.length; i++)
		{
			lines[i].rescale();
		}
	}
	
	public void setGroup(Group grp)
	{
		super.setGroup(grp);
		
		for(int i = 0; i < lines.length; i++)
		{
			lines[i].setGroup(grp);
		}
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		for(int i = 0; i < lines.length; i++)
		{
			lines[i].paint(g);
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				if(param == SHOW)
				{
					setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
				}
				else if(param == COLOR)
				{
					color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
					changed = true;
				}
				else if(param == THICKNESS)
				{
					thickness = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
					changed = true;
				}
				else
				{
					subparam = transform.getSubParam() - 1;
					
					if(subparam >= 0 && subparam < data.length)
					{
						switch(param)
						{
							case X:
								data[subparam][0] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case Y:
								data[subparam][1] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
					}
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		if(param == COUNT)
		{
			return new Integer(data.length);
		}
		else if(param == X)
		{
			subparam--;
			
			if(subparam >= 0 && subparam < data.length)
			{
				return new Double(data[subparam][0]);
			}
		}
		else if(param == Y)
		{
			subparam--;
			
			if(subparam >= 0 && subparam < data.length)
			{
				return new Double(data[subparam][1]);
			}
		}
		else if(param == THICKNESS)
		{
			return new Double(thickness);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		if(param == COUNT)
		{
			double[][] p = new double[((Integer)value).intValue()][2];
			int minlength = Math.min(data.length, p.length);
			
			for(int i = 0; i < minlength; i++)
			{
				p[i][0] = data[i][0];
				p[i][1] = data[i][1];
			}
			
			data = p;
		}
		else if(param == X)
		{
			subparam--;
			
			if(subparam >= 0 && subparam < data.length)
			{
				data[subparam][0] = ((Double)value).doubleValue();
			}
		}
		else if(param == Y)
		{
			subparam--;
			
			if(subparam >= 0 && subparam < data.length)
			{
				data[subparam][1] = ((Double)value).doubleValue();
			}
		}
		else if(param == THICKNESS)
		{
			thickness = ((Double)value).doubleValue();
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<polyline");
		
		ps.print(" points=\"");
		ps.print(Integer.toString(getScaled(data[0][0], 0)) + " " + Integer.toString(getScaled(data[0][1], 1)));
		
		for(int i = 1; i < data.length; i++)
		{
			ps.print(", " + Integer.toString(getScaled(data[i][0], 0)) + " " + Integer.toString(getScaled(data[i][1], 1)));
		}
		
		ps.print("\"");
		
		ps.print(" stroke-width=\"" + Integer.toString(getScaled(thickness, 4)) + "\"");
		ps.print(" stroke-linecap=\"round\"");
		ps.print(" stroke-linejoin=\"round\"");
		
		writeSVGTail(ps, false, false);
		
		ps.println("/>");
	}
}