package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class ThickRect extends VectorElement
{
	protected ThickLine[] lines = new ThickLine[4];
	protected double[] data = new double[4];
	protected double thickness;
	
	public ThickRect()
	{
		data[0] = 0;
		data[1] = 0;
		data[2] = 0;
		data[3] = 0;
		
		thickness = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		data[0] = dis.readFloat();
		data[1] = dis.readFloat();
		data[2] = dis.readFloat();
		data[3] = dis.readFloat();
		
		thickness = dis.readFloat();
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeFloat((float)data[0]);
		dos.writeFloat((float)data[1]);
		dos.writeFloat((float)data[2]);
		dos.writeFloat((float)data[3]);
		
		dos.writeFloat((float)thickness);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		lines[0] = new ThickLine(color, NORMAL, data[0], data[1], data[0] + data[2], data[1], thickness);
		lines[1] = new ThickLine(color, NORMAL, data[0], data[1], data[0], data[1] + data[3], thickness);
		lines[2] = new ThickLine(color, NORMAL, data[0] + data[2], data[1], data[0] + data[2], data[1] + data[3], thickness);
		lines[3] = new ThickLine(color, NORMAL, data[0], data[1] + data[3], data[0] + data[2], data[1] + data[3], thickness);
		
		lines[0].setGroup(group);
		lines[1].setGroup(group);
		lines[2].setGroup(group);
		lines[3].setGroup(group);
	}
	
	public void rescale()
	{
		lines[0].rescale();
		lines[1].rescale();
		lines[2].rescale();
		lines[3].rescale();
	}
	
	public void setGroup(Group grp)
	{
		super.setGroup(grp);
		
		lines[0].setGroup(grp);
		lines[1].setGroup(grp);
		lines[2].setGroup(grp);
		lines[3].setGroup(grp);
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		lines[0].paint(g);
		lines[1].paint(g);
		lines[2].paint(g);
		lines[3].paint(g);
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case X:
						data[0] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case Y:
						data[1] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case WIDTH:
						data[2] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case HEIGHT:
						data[3] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case THICKNESS:
						thickness = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		switch(param)
		{
			case X:
				return new Double(data[0]);
			
			case Y:
				return new Double(data[1]);
			
			case WIDTH:
				return new Double(data[2]);
			
			case HEIGHT:
				return new Double(data[3]);
			
			case THICKNESS:
				return new Double(thickness);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		switch(param)
		{
			case X:
				data[0] = ((Double)value).doubleValue();
				break;
			
			case Y:
				data[1] = ((Double)value).doubleValue();
				break;
			
			case WIDTH:
				data[2] = ((Double)value).doubleValue();
				break;
			
			case HEIGHT:
				data[3] = ((Double)value).doubleValue();
				break;
			
			case THICKNESS:
				thickness = ((Double)value).doubleValue();
				break;
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<rect");
		
		ps.print(" x=\"" + Integer.toString(getScaled(data[0], 0)) + "\"");
		ps.print(" y=\"" + Integer.toString(getScaled(data[1], 1)) + "\"");
		ps.print(" width=\"" + Integer.toString(getScaled(data[2], 2)) + "\"");
		ps.print(" height=\"" + Integer.toString(getScaled(data[3], 3)) + "\"");
		
		ps.print(" stroke-width=\"" + Integer.toString(getScaled(thickness, 4)) + "\"");
		ps.print(" stroke-linejoin=\"round\"");
		
		writeSVGTail(ps, false, false);
		
		ps.println("/>");
	}
}