package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class ThickTriangle extends VectorElement
{
	protected ThickLine[] lines = new ThickLine[3];
	protected double[] data = new double[6];
	protected double thickness;
	
	public ThickTriangle()
	{
		data[0] = 0;
		data[1] = 0;
		data[2] = 0;
		data[3] = 0;
		data[4] = 0;
		data[5] = 0;
		
		thickness = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		data[0] = dis.readFloat();
		data[1] = dis.readFloat();
		data[2] = dis.readFloat();
		data[3] = dis.readFloat();
		data[4] = dis.readFloat();
		data[5] = dis.readFloat();
		
		thickness = dis.readFloat();
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeFloat((float)data[0]);
		dos.writeFloat((float)data[1]);
		dos.writeFloat((float)data[2]);
		dos.writeFloat((float)data[3]);
		dos.writeFloat((float)data[4]);
		dos.writeFloat((float)data[5]);
		
		dos.writeFloat((float)thickness);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		lines[0] = new ThickLine(color, NORMAL, data[0], data[1], data[2], data[3], thickness);
		lines[1] = new ThickLine(color, NORMAL, data[2], data[3], data[4], data[5], thickness);
		lines[2] = new ThickLine(color, NORMAL, data[4], data[5], data[0], data[1], thickness);
		
		lines[0].setGroup(group);
		lines[1].setGroup(group);
		lines[2].setGroup(group);
	}
	
	public void rescale()
	{
		lines[0].rescale();
		lines[1].rescale();
		lines[2].rescale();
	}
	
	public void setGroup(Group grp)
	{
		super.setGroup(grp);
		
		lines[0].setGroup(grp);
		lines[1].setGroup(grp);
		lines[2].setGroup(grp);
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		lines[0].paint(g);
		lines[1].paint(g);
		lines[2].paint(g);
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				subparam = transform.getSubParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case X:
						switch(subparam)
						{
							case 1:
								data[0] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 2:
								data[2] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 3:
								data[4] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
						break;
					
					case Y:
						switch(subparam)
						{
							case 1:
								data[1] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 2:
								data[3] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 3:
								data[5] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
						break;
					
					case THICKNESS:
						thickness = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		if(param == X)
		{
			if(subparam == 1)
			{
				return new Double(data[0]);
			}
			else if(subparam == 2)
			{
				return new Double(data[2]);
			}
			else if(subparam == 3)
			{
				return new Double(data[4]);
			}
		}
		else if(param == Y)
		{
			if(subparam == 1)
			{
				return new Double(data[1]);
			}
			else if(subparam == 2)
			{
				return new Double(data[3]);
			}
			else if(subparam == 3)
			{
				return new Double(data[5]);
			}
		}
		else if(param == THICKNESS)
		{
			return new Double(thickness);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		if(param == X)
		{
			if(subparam == 1)
			{
				data[0] = ((Double)value).doubleValue();
			}
			else if(subparam == 2)
			{
				data[2] = ((Double)value).doubleValue();
			}
			else if(subparam == 3)
			{
				data[4] = ((Double)value).doubleValue();
			}
		}
		else if(param == Y)
		{
			if(subparam == 1)
			{
				data[1] = ((Double)value).doubleValue();
			}
			else if(subparam == 2)
			{
				data[3] = ((Double)value).doubleValue();
			}
			else if(subparam == 3)
			{
				data[5] = ((Double)value).doubleValue();
			}
		}
		else if(param == THICKNESS)
		{
			thickness = ((Double)value).doubleValue();
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<polygon");
		
		ps.print(" points=\"");
		ps.print(Integer.toString(getScaled(data[0], 0)) + " " + Integer.toString(getScaled(data[1], 1)));
		ps.print(", " + Integer.toString(getScaled(data[2], 0)) + " " + Integer.toString(getScaled(data[3], 1)));
		ps.print(", " + Integer.toString(getScaled(data[4], 0)) + " " + Integer.toString(getScaled(data[5], 1)));
		ps.print("\"");
		
		ps.print(" stroke-width=\"" + Integer.toString(getScaled(thickness, 4)) + "\"");
		ps.print(" stroke-linejoin=\"round\"");
		
		writeSVGTail(ps, false, false);
		
		ps.println("/>");
	}
}