package com.vmx;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class FontWidthCache
{
	protected static Hashtable fwcs = new Hashtable();
	
	/**
	 * Получить кэш ширины для шрифта font
	 */
	public static FontWidthCache getCache(Font font)
	{
		FontWidthCache fwc = (FontWidthCache)fwcs.get(font);

		if(fwc == null)
		{
			fwc = new FontWidthCache(font);
			fwcs.put(font, fwc);
		}

		return fwc;
	}
	
	protected Font font;
	protected byte caches[][];
	
	/**
	 * Защищённый конструктор
	 */
	protected FontWidthCache(Font font)
	{
		this.font = font;
		
		caches = new byte[256][];
		
		for(int i = 0; i < 256; i++)
		{
			caches[i] = null;
		}
	}
	
	/**
	 * Подсчитать (или взять из кэша) и вернуть ширину символа ch
	 */
	public int charWidth(char ch)
	{
		int hi = (ch >> 8) & 0xFF;
		int lo = (ch) & 0xFF;
		
		if(caches[hi] == null)
		{
			caches[hi] = new byte[256];
			
			for(int i = 0; i < 256; i++)
			{
				caches[hi][i] = -1;
			}
		}
		
		if(caches[hi][lo] == -1)
		{
			caches[hi][lo] = (byte)font.charWidth(ch);
		}
		
		return ((int)caches[hi][lo]) & 0xFF;
	}

	/**
	 * Подсчитать и вернуть ширину строки s
	 */
	public int stringWidth(String s)
	{
		int l = s.length(), i, r;

		for(r = 0, i = 0; i < l; i++)
		{
			r += charWidth(s.charAt(i));
		}

		return r;
	}

	/**
	 * Подсчитать и вернуть высоту строки s
	 */
	public int stringHeight(String s)
	{
		if(s == null)
		{
			return 0;
		}
		
		int i, l = s.length(), c;
		
		for(c = 1, i = 0; i < l; i++)
		{
			if(s.charAt(i) == '\n')
			{
				c++;
			}
		}
		
		return c * font.getHeight();
	}
	
//	private static void out(String s)
//	{
//		System.out.println("[FontWidthCache] " + s);
//	}
}
