package com.vmx;

import java.io.*;

public class OutputStreamEncoder
{
	OutputStream os;
	int enc;

	/**
	 * Конструктор
	 */
	public OutputStreamEncoder(OutputStream os, int enc) // throws UnsupportedEncodingException
	{
		this.enc = enc;
		this.os = os;
	}
	
	/**
	 * Записать BOM сигнатуру
	 */
	public void writeBOM() throws IOException
	{
		if(enc == StringEncoder.ENC_UTF8)
		{
			os.write(0xEF);
			os.write(0xBB);
			os.write(0xBF);
		}
		else if(enc == StringEncoder.ENC_UTF16N)
		{
			os.write(0xFE);
			os.write(0xFF);
		}
		else if(enc == StringEncoder.ENC_UTF16L)
		{
			os.write(0xFF);
			os.write(0xFE);
		}
	}
	
	/**
	 * Записать символ
	 */
	public void writeChar(char ch) throws IOException
	{
		if(enc >= 0)
		{
			os.write(StringEncoder.encodeChar(ch, enc));
		}
		else if(enc == StringEncoder.ENC_UTF8)
		{
			if(ch <= 0x7F)
			{
				os.write(ch);
			}
			else if(ch <= 0x7FF)
			{
				os.write(0xC0 | ((ch >> 6) & 0x1F));
				os.write(0x80 | (ch & 0x3F));
			}
			else
			{
				os.write(0xE0 | ((ch >> 12) & 0xF));
				os.write(0x80 | ((ch >> 6) & 0x3F));
				os.write(0x80 | (ch & 0x3F));
			}
		}
		else if(enc == StringEncoder.ENC_UTF16N)
		{
			os.write(ch >>> 8);
			os.write(ch & 0xFF);
		}
		else if(enc == StringEncoder.ENC_UTF16L)
		{
			os.write(ch & 0xFF);
			os.write(ch >>> 8);
		}
	}

	/**
	 * Записать строку
	 */
	public void writeString(String text) throws IOException
	{
		char[] as = text.toCharArray();

		for(int i = 0; i < as.length; i++)
		{
			writeChar(as[i]);
		}
	}

	/**
	 * Закрытие кодировщика вместе с потоком, на котором он основан
	 */
	public void close() throws IOException
	{
		os.close();
	}
	
//	private static void out(String s)
//	{
//		System.out.println("[OutputStreamEncoder] " + s);
//	}
}
