package com.vmx;

import java.io.EOFException;

public class StringIterator implements CharacterIterator
{
	protected String text;
	protected int index, length;

	public StringIterator(String text)
	{
		this.text = text;

		index = 0;
		length = text.length();
	}

	public char readChar() throws EOFException
	{
		if(index >= length)
		{
			throw new EOFException();
		}

		return text.charAt(index++);
	}

	public char readCharBack() throws EOFException
	{
		if(index <= 0)
		{
			throw new EOFException();
		}

		return text.charAt(--index);
	}

	public int available()
	{
		return length - index;
	}

	public int getCapacity()
	{
		return length;
	}

	public int getPosition()
	{
		return index;
	}

	public void setPosition(int pos)
	{
		index = pos;

		if(index < 0)
		{
			index = 0;
		}
		else if(index >= length)
		{
			index = length - 1;
		}
	}

	public void skip(int count)
	{
		setPosition(index + count);
	}

	public void rewind(int count)
	{
		setPosition(index - count);
	}
}