package filemanager;

import java.io.*;
import com.one.*;
import com.vmx.*;
import java.util.Vector;
import javax.microedition.lcdui.Image;

/**
 * Класс содержит цветовую схему
 */
public class ColorScheme
{
	public static final int SCHEME_CUSTOM = -1;
	
	public static String[] schemes;
	
	public static final int fore		= 0,
							altfore		= 1,
							hlfore		= 2,
							ltborder	= 3,
							mdborder	= 4,
							dkborder	= 5,
							disabled	= 6,
							back1		= 7,
							back2		= 8,
							selfore		= 9,
							selback1	= 10,
							selback2	= 11,
							mnfore		= 12,
							mnaltfore	= 13,
							mnback1		= 14,
							mnback2		= 15,
							mnselfore	= 16,
							mnselback1	= 17,
							mnselback2	= 18,
							skfore		= 19,
							skselfore	= 20,
							skselback1	= 21,
							skselback2	= 22,
							drap		= 23,
							sbline		= 24,
							sbfore		= 25;

	public static int[] colors = new int[]
	{
		0xFF000080, // Fore
		0xFF008000, // AltFore
		0xFFFF0000, // HLFore

		0xFFFFFFFF, // LTBorder
		0xFF000080, // MDBorder
		0xFF000000, // DKBorder

		0xFF808080, // Disabled

		0xFFD0D0D0, // Back1
		0xFFD0D0D0, // Back2
		0xFFFFFFFF, // SelFore
		0xFF000080, // SelBack1
		0xFF000080, // SelBack2
		
		0xFF000080, // MnFore
		0xFF008000, // MnAltFore
		0xFFD0D0D0, // MnBack1
		0xFFD0D0D0, // MnBack2
		0xFFFFFFFF, // MnSelFore
		0xFF000080, // MnSelBack1
		0xFF000080, // MnSelBack2

		0xFF000080, // SKFore
		0xFFFFFFFF, // SKSelFore
		0xFF000080, // SKSelBack1
		0xFF000080, // SKSelBack2

		0xD0D0D0D0, // Drap

		0xFFFFFFFF, // SBLine
		0xFF000080  // SBFore
	};

	public static String[] cnames = new String[]
	{
		"Fore",
		"AltFore",
		"HLFore",

		"LTBorder",
		"MDBorder",
		"DKBorder",

		"Disabled",

		"Back1",
		"Back2",
		"SelFore",
		"SelBack1",
		"SelBack2",

		"MnFore",
		"MnAltFore",
		"MnBack1",
		"MnBack2",
		"MnSelFore",
		"MnSelBack1",
		"MnSelBack2",

		"SKFore",
		"SKSelFore",
		"SKSelBack1",
		"SKSelBack2",

		"Drap",

		"SBLine",
		"SBFore"
	};
	
	public static void readSchemeList()
	{
		Vector v = new Vector();
		
		try
		{
			InputStreamDecoder ini = InputStreamDecoder.getResourceDecoder("/style/style.ini");
			IniRecord record = null;
			
			while((record = IniRecord.getNextRecord(ini)) != null)
			{
				v.addElement(record.value);
			}
			
			ini.close();
		}
		catch(Exception e)
		{
			ErrScreen.showErrMsg(43, e);
		}
		
		schemes = new String[v.size()];
		v.copyInto(schemes);
	}
	
	public static boolean loadColorScheme(int scheme) throws IOException
	{
		if(scheme < 0 || scheme >= schemes.length)
		{
			return false;
		}

		PlainPackage ppk = new PlainPackage();
		ppk.init(new BufferedInputStream(AuxClass.getResourceAsStream("/style/" + schemes[scheme] + ".ncs")));

		boolean flag = loadModernColorScheme(ppk);

		ppk.close();

		return flag;
	}

	public static void loadLegacyColorScheme(DataInputStream dis) throws IOException
	{
		colors[fore]		= dis.readInt();
		colors[altfore]		= dis.readInt();
		colors[hlfore]		= dis.readInt();
		colors[dkborder]	= dis.readInt();
		colors[disabled]	= dis.readInt();
		colors[back1]		= dis.readInt();
		colors[back2]		= dis.readInt();
		colors[selfore]		= dis.readInt();
		colors[selback1]	= dis.readInt();
		colors[selback2]	= dis.readInt();

		colors[ltborder] = colors[selfore];
		colors[mdborder] = colors[fore];

		colors[mnfore] = colors[fore];
		colors[mnaltfore] = colors[altfore];
		colors[mnback1] = colors[back1];
		colors[mnback2] = colors[back2];
		colors[mnselfore] = colors[selfore];
		colors[mnselback1] = colors[selback1];
		colors[mnselback2] = colors[selback2];

		colors[skfore] = colors[fore];
		colors[skselfore] = colors[selfore];
		colors[skselback1] = colors[selback1];
		colors[skselback2] = colors[selback2];

		colors[sbline] = colors[fore];
		colors[sbfore] = colors[fore];

		for(int i = 0; i < colors.length; i++)
		{
			colors[i] |= 0xFF000000;
		}

		colors[drap] = (colors[back1] & 0xFFFFFF) | 0xC0000000; // (((((colors[back1] >> 16) & 0xFF) + ((colors[back1] >> 8) & 0xFF) + (colors[back1] & 0xFF)) / 3) << 24);
	}

	public static boolean loadModernColorScheme(PlainPackage ppk) throws IOException
	{
		boolean flag = false;

		InputStream is = ppk.getInputStream(ppk.getEntry("scheme.ini"));

		if(is != null)
		{
			InputStreamDecoder isd = InputStreamDecoder.getStreamDecoder(is);
			IniFile ini = new IniFile(isd, true);
			isd.close();

			for(int i = 0; i < colors.length; i++)
			{
				colors[i] = AuxClass.parseHexInt(ini.getRecord("Colors", cnames[i]), colors[i]);
			}
		}

		is = ppk.getInputStream(ppk.getEntry("images.ini"));

		if(is != null)
		{
			InputStreamDecoder ini = InputStreamDecoder.getStreamDecoder(is);
			IniRecord record = null;

			InputStream iis;

			while((record = IniRecord.getNextRecord(ini)) != null)
			{
				iis = ppk.getInputStream(ppk.getEntry(record.value));

				if(iis != null)
				{
					try
					{
						ImageProcessor.addImageToCache(record.key, Image.createImage(iis));
						iis.close();
					}
					catch(Exception e)
					{
					}
				}
			}

			ini.close();
		}

		is = ppk.getInputStream(ppk.getEntry("icons.ini"));

		if(is != null)
		{
			ProgressBar.show();

			InputStreamDecoder ini = InputStreamDecoder.getStreamDecoder(is);
			images.loadIcons(ini, ProgressBar.getProgressCallback(), options.noEffects);
			ini.close();

			flag = true;
		}

		is = ppk.getInputStream(ppk.getEntry("modules.ini"));

		if(is != null)
		{
			ProgressBar.show();
			
			InputStreamDecoder ini = InputStreamDecoder.getStreamDecoder(is);
			ModuleRegistry.loadIcons(ini, ProgressBar.getProgressCallback(), options.noEffects);
			ini.close();

			flag = true;
		}

		ImageProcessor.releaseCachedImages();

		ProgressBar.hide();

		return flag;
	}

	public static void saveColorScheme(OutputStream os) throws IOException
	{
		IniFile ini = new IniFile(false);

		for(int i = 0; i < colors.length; i++)
		{
			ini.addRecord("Colors", cnames[i], Integer.toHexString(colors[i]).toUpperCase());
		}

		OutputStreamEncoder ose = new OutputStreamEncoder(os, StringEncoder.ENC_DEFAULT);
		ose.writeBOM();

		ini.write(ose);

		ose.close();
	}

	public static void readSchemeData(DataInputStream dis) throws IOException
	{
		int count = dis.readInt();

		if(count == colors.length)
		{
			for(int i = 0; i < count; i++)
			{
				colors[i] = dis.readInt();
			}
		}
		else
		{
			for(int i = 0; i < count; i++)
			{
				dis.readInt();
			}
		}
	}

	public static void writeSchemeData(DataOutputStream dos) throws IOException
	{
		dos.writeInt(colors.length);

		for(int i = 0; i < colors.length; i++)
		{
			dos.writeInt(colors[i]);
		}
	}
}
