package filemanager;

import com.one.Operation;
import com.vmx.Locale;
import java.util.Enumeration;
import java.util.Vector;

public class CopyMoveThread extends Operation
{
	protected String targetPath;

	public CopyMoveThread(String targetPath)
	{
		this.targetPath = targetPath;
	}
	
	public void run()
	{
		Enumeration files;
		
		if(callback != null)
		{
			files = Buffer.getBuffer();
			long size = 0;
			
			while(enabled && files.hasMoreElements())
			{
				size += filesystem.getSize((String)files.nextElement(), true);
			}
			
			callback.setMax((int)size);
		}
		
		// папка, куда копируем/перемещаем
		String targetFileFullName;
		
		// файл для операции
		String sourceFileFullName;
		String sourceOnlyName;
		boolean mustMove;
		boolean forAll = false, yes = false, fileExists = false;
		Vector vector = new Vector();
		
		files = Buffer.getBuffer();
		
		while(enabled && files.hasMoreElements())
		{
			sourceFileFullName = (String)files.nextElement();
			sourceOnlyName = sourceFileFullName.substring(noLastSlash(sourceFileFullName).lastIndexOf('/') + 1);
			targetFileFullName = targetPath + sourceOnlyName;
			
			fileExists = filesystem.isFileExist(targetFileFullName);
			mustMove = Buffer.isMoved(sourceFileFullName); // true, если надо перемещать!

			if(fileExists)
			{
				// Если копируем файл в ту же папку, то просто даем копии новое имя, как это делает винда.
				// Иначе спрашиваем, что делать.

				if(sourceFileFullName.equalsIgnoreCase(targetFileFullName))
				{
					String name, ext;

					if(sourceOnlyName.endsWith("/"))
					{
						name = sourceOnlyName.substring(0, sourceOnlyName.length() - 1);
						ext = "/";
					}
					else
					{
						int index = sourceOnlyName.lastIndexOf('.');

						if(index >= 0)
						{
							name = sourceOnlyName.substring(0, index);
							ext = sourceOnlyName.substring(index);
						}
						else
						{
							name = sourceOnlyName;
							ext = "";
						}
					}
					
					targetFileFullName = targetPath + Locale.getString(this, Locale.FIRST_COPY_NAME, name) + ext;
					fileExists = filesystem.isFileExist(targetFileFullName);

					if(fileExists)
					{
						int copynum = 2;

						do
						{
							targetFileFullName = targetPath + Locale.getString(this, Locale.NEXT_COPY_NAME, new String[] { name, Integer.toString(copynum++) }) + ext;
							fileExists = filesystem.isFileExist(targetFileFullName);
						}
						while(fileExists);
					}

					mustMove = false;
				}
				else if(!forAll) // файл существует и ещё не было команды "... для всех!"
				{
					alConfirmOverwrite al = new alConfirmOverwrite(sourceOnlyName, main.FileSelect);
					main.dsp.setCurrent(al);
					al.t.start();

					try
					{
						al.t.join(); // ждём, пока он СДОХНЕТ :)
					}
					catch(InterruptedException x)
					{
					}

					yes = false;

					if(al.modalResult == al.cmdYes || al.modalResult == al.cmdYesForAll)
					{
						// если да или да для всех => yes!
						yes = true;
					}

					if(al.modalResult == al.cmdCancel)
					{
						// если "отмена", значит стоп.
						break;
					}

					if(al.modalResult == al.cmdYesForAll || al.modalResult == al.cmdNoForAll)
					{
						// команда для всех
						forAll = true;
					}

					al = null;
					Buffer.displayCurrentOperation();
				}
			}
			
			if(!fileExists || yes)
			{
				if(!mustMove) // копирование
				{
					if(!filesystem.copyFile(sourceFileFullName, targetFileFullName, callback, vector))
					{
						printErrors(vector, Locale.FILE_NOT_COPIED);
						vector.removeAllElements();
					}
				}
				else // перемещение
				{
					if(!filesystem.copyFile(sourceFileFullName, targetFileFullName, callback, vector)) // скопирован?
					{
						printErrors(vector, Locale.FILE_NOT_MOVED);
						vector.removeAllElements();
					}

					if(filesystem.isReadOnly(sourceFileFullName)) // источник readonly
					{
						errors.append(Locale.getString(this, Locale.SOURCE_FILE_READONLY_BE_COPIED, sourceOnlyName));
					}
					else
					{
						filesystem.deleteFile(sourceFileFullName, true, null); // удаляем исходный файл
					}
				}
			}
		}
	}

	protected void printErrors(Vector vector, int pattern)
	{
		for(int i = 0; i < vector.size(); i++)
		{
			errors.append(Locale.getString(this, pattern, (String[])vector.elementAt(i)));
		}
	}
	
	/**
	 * Обрезание последнего слэша у s
	 */
	public static String noLastSlash(String s)
	{
		if(s.charAt(s.length() - 1) == '/')
		{
			return s.substring(0, s.length() - 1);
		}
		
		return s;
	}
}
