package filemanager;

import com.one.Operation;
import com.vmx.Locale;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class Deleter extends Operation implements CommandListener
{
	protected Object parent;

	public void start()
	{
		if(Buffer.getSize() == 0)
		{
			main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.BUFFER_EMPTY), AlertType.WARNING, 3000, main.dsp.getCurrent());
			return;
		}

		GraphicAlert alert = new GraphicAlert(Locale.getString(this, Locale.CONFIRMATION), Locale.getString(this, Locale.DEL_ALL_IN_BUFFER), images.getAlertIcon(AlertType.CONFIRMATION), AlertType.CONFIRMATION);
		alert.addCommand(new Command(Locale.getString(this, Locale.YES_CMD), Command.OK, 1));
		alert.addCommand(new Command(Locale.getString(this, Locale.NO_CMD), Command.CANCEL, 2));
		alert.setCommandListener(this);

		parent = main.dsp.getCurrent();
		main.dsp.setCurrent(alert);
	}

	public void commandAction(Command c, Displayable dp)
	{
		if(c.getCommandType() == Command.OK)
		{
			Enumeration files = Buffer.getBuffer();
			Vector vector = new Vector(Buffer.getSize());

			while(files.hasMoreElements())
			{
				vector.addElement(files.nextElement());
			}

			files = vector.elements();
			Buffer.clear();

			while(files.hasMoreElements())
			{
				Buffer.add((String)files.nextElement(), true);
			}

			(new CopyMoveThread("null:/")).start();
		}
		else
		{
			main.dsp.setCurrent(parent);
		}
	}
}