package filemanager;

import javax.microedition.lcdui.*;
import com.vmx.*;
import com.one.*;

public class GraphicAlert extends gkcCanvas implements AutoAdvanceScreen, ProgressCallback
{
//	public static final int SMALL_SPACE = 2;
//	public static final int MEDIUM_SPACE = 4;
//	public static final int LARGE_SPACE = 7;
	
	protected static Display alertDisplay;
	
	protected int w, h;
	protected int header, footer;
	
	protected CommandMenu cmenu;
	
	protected long maxval, value;
	protected int pbx, pby, pbw, pbh, pbfill;
	protected String percent;
	protected int perx, pery;
	protected boolean useindicator;
	protected boolean percentmode;
	protected boolean cancelflag;
	
	protected Image image;
	protected String title;
	protected int ttlx, ttly, ttlw;
	protected int imgx, imgy;
	
	protected String text;
	protected String[] message;
	protected int[] msgx;
	protected int msgy, msgheight;
	protected int maxMsgWidth, maxMsgHeight;
	protected int linesPerScreen;
	
	protected AbstractFont f;
	protected int fh;
	
	protected boolean isShown;
	protected long lastpaint;
	
	protected AlertType alertType;
	protected int timeout;
	
	public static void setAlertDisplay(Display d)
	{
		alertDisplay = d;
	}
	
	public GraphicAlert(String title)
	{
		this(title, null, null, null);
	}
	
	public GraphicAlert(String title, String text, Image image, AlertType type)
	{
		isShown = false;
		setFullScreenMode(true);
		
		w = getWidth();
		h = getHeight();
		
		cmenu = new CommandMenu(getRenderer(), null, w, h, AbstractFont.SIZE_MEDIUM, false, true, true, false, false);
		
		f = AbstractFont.getFont(AbstractFont.FACE_SYSTEM, AbstractFont.STYLE_PLAIN, AbstractFont.SIZE_MEDIUM);
		fh = f.getHeight();
		
		header = fh * 3 / 2 + 1;
		footer = cmenu.getSoftHeight() + 1;
		
		ttlx = fh / 2;
		ttly = (header - fh - 1) / 2;
		
		pbx = ttlx;
		pbw = w - pbx * 2 - 1;
		pbh = fh * 3 / 2;
		pby = h - cmenu.getSoftHeight() - pbh - fh;

		percentmode = true;
		
		pery = pby + (pbh - fh) / 2;
		
		maxMsgWidth = pbw;
				
		setMax(1);
		setProgress(0);
		
		setTimeout(Alert.FOREVER);
		setIndicator(false);
		
		setTitle(title);
		setString(text);
		setImage(image);
		setType(type);
	}
	
	public void addCommand(Command c)
	{
		cmenu.addCommand(c);
		repaintAll();
	}
	
	public void removeCommand(Command c)
	{
		cmenu.removeCommand(c);
		repaintAll();
	}
	
	public void setCommandListener(CommandListener cl)
	{
		cmenu.setCommandListener(cl);
	}
	
	public void setTitle(String ttl)
	{
		if(ttl != null)
		{
			title = ttl;
		}
		else
		{
			title = "";
		}
		
		ttlw = f.stringWidth(title) + fh;
	}
	
	public void setImage(Image img)
	{
		image = img;
		
		if(image != null)
		{
			imgx = w - image.getWidth() - ttlx / 2;
			imgy = ttlx / 2;
		}
	}
	
	public void setIndicator(boolean useindicator)
	{
		this.useindicator = useindicator;
		
		if(useindicator)
		{
			maxMsgHeight = pby - header - fh * 2;
		}
		else
		{
			maxMsgHeight = h - footer - header - fh * 2;
		}

		linesPerScreen = maxMsgHeight / fh;
		
		setString(text);
	}
	
	public void setString(String str)
	{
		//System.out.println(str);

		if(str != null)
		{
			text = str;
		}
		else
		{
			text = "";
		}
		
		message = f.splitString(text, maxMsgWidth);
		msgheight = fh * message.length;
		
		msgx = new int[message.length];
		
		for(int i = 0; i < message.length; i++)
		{
			msgx[i] = pbx + (maxMsgWidth - f.stringWidth(message[i])) / 2;
		}
		
		msgy = (maxMsgHeight - msgheight) / 2;
		
		if(msgy < 0)
		{
			msgy = 0;
			timeout = Alert.FOREVER;
		}
		
		msgy += header + fh;
		
		repaintAll();
	}
	
	public void setTimeout(int time)
	{
		timeout = time;
	}
	
	public void setType(AlertType type)
	{
		alertType = type;
	}
	
	public void setMax(int max)
	{
		maxval = max;

		if(maxval >= 0)
		{
			if(maxval < 1)
			{
				maxval = 1;
			}

			if(value > maxval)
			{
				value = maxval;
			}
		}
		
		updateProgress();
	}
	
	public void setProgress(int progress)
	{
		value = progress;

		if(maxval >= 0)
		{
			if(value < 0)
			{
				value = 0;
			}
			else if(value > maxval)
			{
				value = maxval;
			}
		}
		
		updateProgress();
	}
	
	public void rise(int plus)
	{
		if(maxval < 0)
		{
			return;
		}

		setMax((int)(maxval + plus));
	}

	public void progress(int plus)
	{
		setProgress((int)(value + plus));
	}
	
	protected void updateProgress()
	{
		if(maxval > 0)
		{
			pbfill = (int)(pbw * value / maxval);

			if(percentmode)
			{
				percent = Integer.toString((int)(value * 100 / maxval)) + "%";
			}
			else if(maxval >= 0)
			{
				percent = AuxClass.formatNumber(value) + " / " + AuxClass.formatNumber(maxval);
			}
		}
		else
		{
			pbfill = 0;
			percent = AuxClass.formatNumber(value);
		}

		perx = pbx + (pbw - f.stringWidth(percent)) / 2;
		
		if(useindicator)
		{
			repaintAll();
		}
	}

	public void setText(String text)
	{
		setString(text);
	}

	public int getMax()
	{
		return (int)maxval;
	}

	public int getProgress()
	{
		return (int)value;
	}

	public String getText()
	{
		return text;
	}

	public void setPercentMode(boolean mode)
	{
		percentmode = mode;
	}

	public void setCancelFlag(boolean flag)
	{
		cancelflag = flag;
	}

	public boolean getCancelFlag()
	{
		return cancelflag;
	}
	
	public void showNotify()
	{
		isShown = true;
		
		if(options.playAlertSounds && alertType != null && alertDisplay != null)
		{
			alertType.playSound(alertDisplay);
		}

		main.startLightControl(true);
	}
	
	public void hideNotify()
	{
		isShown = false;
		main.startLightControl(false);
	}
	
	protected void repaintAll()
	{
		repaint();
		
		if(isShown && System.currentTimeMillis() - lastpaint > 100)
		{
			serviceRepaints();
			lastpaint = System.currentTimeMillis();
		}
	}
	
	public void paint(ExtGraphics g)
	{
		//g.setColor(ColorScheme.colors[ColorScheme.back1]);
		//g.fillRect(0, 0, w, h);

		images.drawVGradient(g, ColorScheme.colors[ColorScheme.back1], ColorScheme.colors[ColorScheme.back2], 0, 0, w, h, options.ditherGradients);
		
		g.setFont(f);
		
		g.setColor(ColorScheme.colors[ColorScheme.fore]);
		g.drawString(title, ttlx, ttly, Graphics.LEFT | Graphics.TOP);
		
		g.setColor(ColorScheme.colors[ColorScheme.ltborder]);
		g.drawLine(0, header - 1, ttlw, header - 1);
		
		if(image != null)
		{
			g.drawImage(image, imgx, imgy, Graphics.LEFT | Graphics.TOP);
		}
		
		g.setClip(pbx, header + fh, maxMsgWidth, maxMsgHeight);
		g.setColor(ColorScheme.colors[ColorScheme.fore]);
		
		for(int i = 0; i < message.length; i++)
		{
			g.drawString(message[i], msgx[i], msgy + i * fh, Graphics.LEFT | Graphics.TOP);
		}
		
		if(useindicator)
		{
			g.setClip(pbx, pby, pbfill, pbh);
			images.drawHGradient(g, ColorScheme.colors[ColorScheme.selback1], ColorScheme.colors[ColorScheme.selback2], pbx, pby, pbw, pbh, options.ditherGradients);
			//g.setColor(ColorScheme.colors[ColorScheme.selback1]);
			//g.fillRect(pbx, pby, pbfill, pbh);

			g.setColor(ColorScheme.colors[ColorScheme.selfore]);
			g.drawString(percent, perx, pery, Graphics.LEFT | Graphics.TOP);
			
			g.setClip(pbx + pbfill, pby, pbw - pbfill, pbh);
			g.setColor(ColorScheme.colors[ColorScheme.fore]);
			g.drawString(percent, perx, pery, Graphics.LEFT | Graphics.TOP);
			
			g.setClip(pbx, pby, pbw, pbh);
			g.setColor(ColorScheme.colors[ColorScheme.ltborder]);
			g.drawRect(pbx, pby, pbw - 1, pbh - 1);
		}
		
		g.setClip(0, 0, w, h);
		cmenu.paint(g);
	}
	
	public void keyPressed(int keyCode)
	{
		keyCode = remapKey(keyCode);

		if(cmenu.keyPressed(keyCode))
		{
			repaintAll();
		}
		else
		{
			if(keyCode == KEY_UP)
			{
				if(msgheight > maxMsgHeight && msgy < header + 2)
				{
					msgy += fh;
				}
			}
			else if(keyCode == KEY_DOWN)
			{
				if(msgheight > maxMsgHeight && msgy + msgheight > header + 2 + maxMsgHeight)
				{
					msgy -= fh;
				}
			}
			else if(keyCode == KEY_LEFT)
			{
				if(msgheight > maxMsgHeight && msgy < header + 2)
				{
					msgy += fh * linesPerScreen;
				}
			}
			else if(keyCode == KEY_RIGHT)
			{
				if(msgheight > maxMsgHeight && msgy + msgheight > header + 2 + maxMsgHeight)
				{
					msgy -= fh * linesPerScreen;
				}
			}
			else
			{
				return;
			}

			repaintAll();
		}
	}
	
	public void keyReleased(int keyCode)
	{
		keyCode = remapKey(keyCode);

		if(cmenu.keyReleased(keyCode))
		{
			repaintAll();
		}
	}
	
	public boolean finiteTimeout()
	{
		return timeout != Alert.FOREVER && cmenu.commandCount() < 2;
	}
	
	public void run()
	{
		if(finiteTimeout())
		{
			try
			{
				Thread.sleep(timeout);
				cmenu.commandAction(Alert.DISMISS_COMMAND, getRenderer());
			}
			catch(InterruptedException ie)
			{
			}
		}
	}
}
