package filemanager;

import com.one.ExtGraphics;
import javax.microedition.lcdui.*;
import java.util.Random;

public class LineEffect
{
	protected int x1, y1, x2, y2;
	protected int[] lndata = new int[12];
	protected long delay;
	
	public LineEffect(int x, int y, int width, int height)
	{
		x1 = x;
		y1 = y;
		x2 = x + width - 1;
		y2 = y + height - 1;
		
		delay = 8000 / Math.min(width, height);
		
		Random rnd = new Random();
		
		lndata[0] = x + Math.abs(rnd.nextInt()) % width;
		lndata[1] = y + Math.abs(rnd.nextInt()) % height;
		lndata[2] = x + Math.abs(rnd.nextInt()) % width;
		lndata[3] = y + Math.abs(rnd.nextInt()) % height;
		
		lndata[4] = rnd.nextInt() > 0 ? 1 : -1;
		lndata[5] = rnd.nextInt() > 0 ? 1 : -1;
		lndata[6] = rnd.nextInt() > 0 ? 1 : -1;
		lndata[7] = rnd.nextInt() > 0 ? 1 : -1;
		
		lndata[8] = rnd.nextInt() > 0 ? 1 : -1;
		lndata[9] = rnd.nextInt() > 0 ? 1 : -1;
		lndata[10] = -lndata[8];
		lndata[11] = -lndata[9];
	}
	
	public void drawLines(ExtGraphics g)
	{
		g.drawLine(lndata[0], y1, lndata[0], y2);
		g.drawLine(x1, lndata[1], x2, lndata[1]);
		g.drawLine(lndata[2], y1, lndata[2], y2);
		g.drawLine(x1, lndata[3], x2, lndata[3]);
	}
	
	public void moveLines()
	{
		if(lndata[8] == 0)
		{
			lndata[8] = 1;
		}
		else
		{
			lndata[0] += lndata[4];
			
			if(lndata[8] == 1)
			{
				lndata[8] = 0;
			}
		}
		
		if(lndata[9] == 0)
		{
			lndata[9] = 1;
		}
		else
		{
			lndata[1] += lndata[5];
			
			if(lndata[9] == 1)
			{
				lndata[9] = 0;
			}
		}
		
		if(lndata[10] == 0)
		{
			lndata[10] = 1;
		}
		else
		{
			lndata[2] += lndata[6];
			
			if(lndata[10] == 1)
			{
				lndata[10] = 0;
			}
		}
		
		if(lndata[11] == 0)
		{
			lndata[11] = 1;
		}
		else
		{
			lndata[3] += lndata[7];
			
			if(lndata[11] == 1)
			{
				lndata[11] = 0;
			}
		}
		
		if(lndata[0] < x1)
		{
			lndata[0] = x1;
			lndata[4] = -lndata[4];
		}
		else if(lndata[0] > x2)
		{
			lndata[0] = x2;
			lndata[4] = -lndata[4];
		}
		
		if(lndata[1] < y1)
		{
			lndata[1] = y1;
			lndata[5] = -lndata[5];
		}
		else if(lndata[1] > y2)
		{
			lndata[1] = y2;
			lndata[5] = -lndata[5];
		}
		
		if(lndata[2] < x1)
		{
			lndata[2] = x1;
			lndata[6] = -lndata[6];
		}
		else if(lndata[2] > x2)
		{
			lndata[2] = x2;
			lndata[6] = -lndata[6];
		}
		
		if(lndata[3] < y1)
		{
			lndata[3] = y1;
			lndata[7] = -lndata[7];
		}
		else if(lndata[3] > y2)
		{
			lndata[3] = y2;
			lndata[7] = -lndata[7];
		}
	}
	
	public long getDelay()
	{
		return delay;
	}
	
	public static void drawTextOutline(ExtGraphics g, String text, int x, int y)
	{
		g.drawString(text, x, y - 1, Graphics.LEFT | Graphics.TOP);
		g.drawString(text, x + 1, y - 1, Graphics.LEFT | Graphics.TOP);
		g.drawString(text, x + 1, y, Graphics.LEFT | Graphics.TOP);
		g.drawString(text, x + 1, y + 1, Graphics.LEFT | Graphics.TOP);
		g.drawString(text, x, y + 1, Graphics.LEFT | Graphics.TOP);
		g.drawString(text, x - 1, y + 1, Graphics.LEFT | Graphics.TOP);
		g.drawString(text, x - 1, y, Graphics.LEFT | Graphics.TOP);
		g.drawString(text, x - 1, y - 1, Graphics.LEFT | Graphics.TOP);
	}
	
	public static void drawTextOutline(ExtGraphics g, String text, int x, int y, int width)
	{
		int sx = x - width;
		int ex = x + width;
		
		int sy = y - width;
		int ey = y + width;
		
		for(x = sx; x <= ex; x++)
		{
			for(y = sy; y <= ey; y++)
			{
				g.drawString(text, x, y, Graphics.LEFT | Graphics.TOP);
			}
		}
	}
	
	public static Image createDrap(int color, int width, int height)
	{
		try
		{
			int[] rgb = new int[width * height];
			
			for(int i = 0; i < rgb.length; i++)
			{
				rgb[i] = color;
			}
			
			return Image.createRGBImage(rgb, width, height, true);
		}
		catch(OutOfMemoryError oome)
		{
			return null;
		}
	}
	
	public static Image createCheckedField(int color1, int color2, int width, int height, int cell)
	{
		Image image = Image.createImage(width, height);
		Graphics g = image.getGraphics();
		
		g.setColor(color1);
		g.fillRect(0, 0, width, height);
		
		g.setColor(color2);
		
		boolean flag = false;
		int cell2 = cell * 2;
		int x, y;
		
		for(x = 0; x < width; x += cell)
		{
			if(flag)
			{
				y = cell;
				flag = false;
			}
			else
			{
				y = 0;
				flag = true;
			}
			
			for(; y < height; y += cell2)
			{
				g.fillRect(x, y, cell, cell);
			}
		}
		
		return image;
	}
	
	public static void drawScaledRGB(ExtGraphics g, int[] rgb, int x, int y, int width, int height, int scale)
	{
		for(int i = 0; i < width; i++)
		{
			for(int j = 0; j < height; j++)
			{
				g.setColor(rgb[i + j * width]);
				g.fillRect(x + i * scale, y + j * scale, scale, scale);
			}
		}
	}
}
