package filemanager;

import com.one.Operation;
import com.one.ModuleRegistry;
import com.one.NameTemplate;
import com.vmx.Locale;
import java.util.Enumeration;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;

public class Renamer extends Operation implements CommandListener, ItemStateListener
{
	protected static final int MIN_DIGITS = 1;
	protected static final int MAX_DIGITS = 8;

	protected Object parent;

	protected TextField tfTemplate;
	protected TextField tfCounterStart;
	protected TextField tfCounterStep;
	protected Gauge gCounterDigits;
	protected TextField tfFind;
	protected TextField tfReplace;
	protected ChoiceGroup cgTargetCase;

	public void start()
	{
		if(Buffer.getSize() == 0)
		{
			main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.BUFFER_EMPTY), AlertType.WARNING, 3000, main.dsp.getCurrent());
			return;
		}

		Form form = new Form(ModuleRegistry.getModuleName(getClass().getName()));

		tfTemplate = new TemplateTextField(Locale.getString(this, Locale.NAME_TEMPLATE), NameTemplate.NAME + " (" + NameTemplate.COUNTER + ")." + NameTemplate.EXTENSION, 256, TextField.ANY);

		tfCounterStart = new TextField(Locale.getString(this, Locale.COUNTER_START), "1", 20, TextField.NUMERIC);
		tfCounterStep = new TextField(Locale.getString(this, Locale.COUNTER_STEP), "1", 20, TextField.NUMERIC);

		gCounterDigits = new Gauge(null, true, MAX_DIGITS - MIN_DIGITS, 1 - MIN_DIGITS);
		itemStateChanged(gCounterDigits);

		tfFind = new TemplateTextField(Locale.getString(this, Locale.FIND_CMD), "", 256, TextField.ANY);
		tfReplace = new TemplateTextField(Locale.getString(this, Locale.REPLACE_WITH), "", 256, TextField.ANY);

		cgTargetCase = new ChoiceGroup(Locale.getString(this, Locale.LETTER_CASE), Choice.EXCLUSIVE);

		cgTargetCase.append(Locale.getString(this, Locale.CASE_UNCHANGED), null);
		cgTargetCase.append(Locale.getString(this, Locale.ALL_LOWERCASE), null);
		cgTargetCase.append(Locale.getString(this, Locale.ALL_UPPERCASE), null);
		cgTargetCase.append(Locale.getString(this, Locale.LINE_FIRST_UPPERCASE), null);
		cgTargetCase.append(Locale.getString(this, Locale.WORD_FIRST_UPPERCASE), null);

		form.append(tfTemplate);
		form.append(tfCounterStart);
		form.append(tfCounterStep);
		form.append(gCounterDigits);
		form.append(tfFind);
		form.append(tfReplace);
		form.append(cgTargetCase);

		form.addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		form.addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.CANCEL, 2));
		form.setCommandListener(this);
		form.setItemStateListener(this);

		parent = main.dsp.getCurrent();
		main.dsp.setCurrent(form);
	}

	public void commandAction(Command c, Displayable dp)
	{
		if(c.getCommandType() == Command.OK)
		{
			Buffer.startOperation(this);
		}
		else
		{
			main.dsp.setCurrent(parent);
		}
	}

	public void itemStateChanged(Item item)
	{
		if(item == gCounterDigits)
		{
			gCounterDigits.setLabel(Locale.getString(this, Locale.DIGIT_CAPACITY, Integer.toString(gCounterDigits.getValue() + MIN_DIGITS)));
		}
	}
	
	/**
     * Функция, осуществляющая собственно переименование
	 */
	public void run()
	{
		String path = null;
		String name = null;
		int index = -1;
		
		if(callback != null)
		{
			callback.setMax(Buffer.getSize());
			callback.setProgress(0);
		}

		NameTemplate template = new NameTemplate(tfTemplate.getString());
		template.setCounter(Integer.parseInt(tfCounterStart.getString()), Integer.parseInt(tfCounterStep.getString()), gCounterDigits.getValue() + MIN_DIGITS);
		template.setReplace(tfFind.getString(), tfReplace.getString());
		template.setTargetCase(cgTargetCase.getSelectedIndex());
		
		try
		{
			Buffer.flattenBuffer();
			Enumeration files = Buffer.getBuffer();
			
			while(enabled && files.hasMoreElements())
			{
				name = (String)files.nextElement();

				if(callback != null)
				{
					callback.setText(name);
				}
				
				index = name.lastIndexOf('/') + 1;
				
				path = name.substring(0, index);
				name = name.substring(index);

				filesystem.renameFile(path, name, template.getNewName(name), null);
				
				if(callback != null)
				{
					callback.progress(1);
				}
			}
		}
		catch(Exception ex)
		{
			logError(ex);
		}
	}
	
//	private static void out(String s)
//	{
//		System.out.println("[Renamer] " + s);
//	}
}
