package filemanager;

import com.vmx.Locale;
import javax.microedition.lcdui.*;
import com.one.*;
import com.vmx.AuxClass;
import com.vmx.ProgressCallback;

public class SplashScreen extends PaintableObject implements ProgressCallback
{
	protected static final int COLOR_GRADATIONS = 8;

	protected Image splashBack;
	protected Image splashAbout;
	protected int width, height;
	protected int curstate, maxstate;
	protected AbstractFont font;
	protected int pbx, pby, pbw, pbh;
	protected int arcsz;

	protected int max, progress;
	protected int pb2x, pb2y, pb2w, pb2h;

	protected long prevtime = -1;
	protected long prevmem = -1;
	
	public SplashScreen()
	{
		setFullScreenMode(true);
		
		width = getWidth();
		height = getHeight();
		
		font = AbstractFont.getFont(AbstractFont.FACE_SYSTEM, AbstractFont.STYLE_PLAIN, AbstractFont.SIZE_LARGE);
		
		pbw = width - 4;
		pbh = 3;
		pbx = 2;
		pby = 2;

		pb2w = pbw;
		pb2h = pbh;
		pb2x = pbx;
		pb2y = pby + pbh + pby;

		progress = 0;
		max = 1;
		
		arcsz = Math.min(pbw, pbh) / 2;
		
		curstate = 0;
		maxstate = 1;

		try
		{
			splashAbout = Image.createImage("/img/about.png");
		}
		catch(Exception e)
		{
		}
	}

	public void createBackground()
	{
		if(images.splashBack != null)
		{
			return;
		}
		
		splashBack = Image.createImage(width, height);
		ExtGraphics g = new ExtGraphics(splashBack.getGraphics());

		int colorA = ColorScheme.colors[AuxClass.randomFromRange(0, ColorScheme.colors.length - 1)];
		int colorB;

		int count = 0;

		do
		{
			colorB = ColorScheme.colors[AuxClass.randomFromRange(0, ColorScheme.colors.length - 1)];
		}
		while((colorA & 0xFFFFFF) == (colorB & 0xFFFFFF) && count++ < ColorScheme.colors.length);

//		int sqsize = width == height ? width / 8 : AuxMath.gcd(width, height) / 2;
//
//		if(sqsize <= 1)
//		{
//			sqsize = (width + height) / 16;
//		}
//
//		int sqxcount = width / sqsize;
//		int sqycount = height / sqsize;
//
//		for(int y = 0; y < sqycount; y++)
//		{
//			for(int x = 0; x < sqxcount; x++)
//			{
//				g.setColor(images.blendColors(colorA, colorB, AuxClass.randomFromRange(0, COLOR_GRADATIONS), COLOR_GRADATIONS));
//				g.fillRect(x * sqsize, y * sqsize, sqsize, sqsize);
//			}
//		}

		images.drawVGradient(g, colorA, colorB, 0, 0, width, height, true);
		
		int msgx = (width - font.stringWidth(Locale.ABOUT_MIDLET_NAME)) / 2;
		int msgy = (height - font.getHeight()) / 2;

		g.setColor(images.blendColors(ColorScheme.colors[ColorScheme.selback1], ColorScheme.colors[ColorScheme.selback2], 1, 2));
		LineEffect.drawTextOutline(g, Locale.ABOUT_MIDLET_NAME, msgx, msgy);

		g.setColor(ColorScheme.colors[ColorScheme.selfore]);
		g.drawString(Locale.ABOUT_MIDLET_NAME, msgx, msgy, Graphics.LEFT | Graphics.TOP);
	}
	
	public void setMaxState(int value)
	{
		maxstate = value;

		repaint();
		serviceRepaints();
	}
	
	public void setState(int value)
	{
		curstate = value;

		System.gc();

		if(prevtime >= 0)
		{
			System.out.println(" " + (System.currentTimeMillis() - prevtime) + " ms, " + (prevmem - Runtime.getRuntime().freeMemory()) + " b");

			prevtime = -1;
			prevmem = -1;
		}

		repaint();
		serviceRepaints();
	}
	
	public void nextState()
	{
		setState(curstate + 1);
	}

	public void debugPrint(String text)
	{
		System.out.print(Integer.toString(curstate) + "> " + text + "... ");

		System.gc();

		prevtime = System.currentTimeMillis();
		prevmem = Runtime.getRuntime().freeMemory();
	}

	public int getMaxState()
	{
		return maxstate;
	}

	public int getState()
	{
		return curstate;
	}

	public void setMax(int max)
	{
		if(max < 1)
		{
			max = 1;
		}

		this.max = max;

		repaint();
		serviceRepaints();
	}

	public void setProgress(int progress)
	{
		if(progress < 0)
		{
			progress = 0;
		}
		else if(progress > max)
		{
			progress = max;
		}

		this.progress = progress;

		repaint();
		serviceRepaints();
	}

	public void rise(int plus)
	{
		setMax(max + plus);
	}

	public void progress(int plus)
	{
		setProgress(progress + plus);
	}

	public void setText(String text)
	{
	}

	public int getMax()
	{
		return max;
	}

	public int getProgress()
	{
		return progress;
	}

	public String getText()
	{
		return "";
	}

	public void setPercentMode(boolean mode)
	{
	}

	public void setCancelFlag(boolean flag)
	{
	}

	public boolean getCancelFlag()
	{
		return false;
	}
	
	public void paint(ExtGraphics g)
	{
		if(images.splashBack != null)
		{
			g.drawImage(images.splashBack, 0, 0, Graphics.LEFT | Graphics.TOP);
		}
		else if(splashBack != null)
		{
			g.drawImage(splashBack, 0, 0, Graphics.LEFT | Graphics.TOP);

//			int colorA = ColorScheme.colors[ColorScheme.back1];
//			int colorB = ColorScheme.colors[ColorScheme.fore];
//
//			for(int y = 0; y < sqycount; y++)
//			{
//				for(int x = 0; x < sqxcount; x++)
//				{
//					g.setColor(images.blendColors(colorA, colorB, sqmatrix[y][x], 8));
//					g.fillRect(x * sqsize, y * sqsize, sqsize, sqsize);
//				}
//			}
//
//			g.setColor(ColorScheme.colors[ColorScheme.back1]);
//			g.fillRoundRect(rrx, rry, rrw, rrh, rra, rra);
//
//			g.setColor(ColorScheme.colors[ColorScheme.fore]);
//			g.drawString(Locale.ABOUT_MIDLET_NAME, msgx, msgy, Graphics.LEFT | Graphics.TOP);
		}
		else
		{
			return;
		}

		if(splashAbout != null)
		{
			g.drawImage(splashAbout, width, height, Graphics.RIGHT | Graphics.BOTTOM);
		}

		g.setColor(ColorScheme.colors[ColorScheme.altfore]);
		
		if(curstate >= 0 && curstate <= maxstate)
		{
			g.fillRect(pbx, pby, pbw * curstate / maxstate, pbh);
		}
		else
		{
			g.fillRect(pbx, pby, pbw, pbh);
		}

		images.fillVLineRect(g, pb2x, pb2y, pb2w * progress / max, pbh);
	}
}
