package filemanager;

import com.vmx.Locale;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.TextField;

public class TemplateTextField extends TextField implements ItemCommandListener
{
	public static boolean useTemplates = true;

	public TemplateTextField(String label, String text, int maxSize, int constraints)
	{
		super(label, text, maxSize, constraints);

		if(useTemplates)
		{
			addCommand(new Command(Locale.getString(this, Locale.TEMPLATES_CMD), Command.ITEM, 1));
			setItemCommandListener(this);
		}
	}

	public void commandAction(Command c, Item item)
	{
		TemplateManager.showTemplateList(this, null);
	}
}
