package filemanager;

import modules.text.cvsTextView;
import com.one.FileSource;
import com.one.ModuleRegistry;
import com.one.PlayList;
import javax.microedition.lcdui.*;
import java.util.Enumeration;
import com.vmx.*;

public class WorkingMenu implements MenuListener
{
	protected cvsMenu mn;

	public WorkingMenu(cvsMenu menu)
	{
		mn = menu;
	}

	/**
	 * Обработчик для меню
	 */
	public void menuAction(int string)
	{
		if(string < 0)
		{
			return;
		}
		else if(string >= Locale.PANEL_NUMS && string < Locale.PANEL_NUMS + 10)
		{
			//main.FileSelect.changePanel(string - Locale.PANEL_NUMS);
			mn.ret();
			main.manager.changePanel(string - Locale.PANEL_NUMS);
			return;
		}
		else if(string >= Locale.FAV_MOD_NUMS && string < Locale.FAV_MOD_NUMS + 10 &&
		        options.favmodules[string - Locale.FAV_MOD_NUMS].length() > 0)
		{
			mn.ret();

			if(!filesystem.isDir(main.currentFile))
			{
				String module = options.favmodules[string - Locale.FAV_MOD_NUMS];

				if(ModuleRegistry.getAction(module) == ModuleRegistry.ACTION_OPEN)
				{
					main.FileSelect.executeFile(new PlayList(main.currentPath + main.currentFile), module, main.manager.currentPanel());
				}
				else
				{
					main.FileSelect.associateAndSelect(module, false);
				}
			}
		}
		else if(string >= Locale.SORT_NONE && string <= Locale.SORT_BY_SIZE)
		{
			options.listSortBy = string - Locale.SORT_NONE;
			main.FileSelect.showWait(main.currentFile);
			return;
		}

		boolean moveit = false;
		//main.currentFile = main.FileSelect.getFileItem(main.FileSelect.getSelectedIndex()).getName();

		main.FileSelect.setMenuType(mn);

		if(string == Locale.PROPERTY_CMD && mn.type == 3 && main.currentPath.endsWith(":/") && "..".equals(main.currentFile))
		{
			string = Locale.DISK_INFO_CMD;
		}

		if(!mn.isActionAllowed(string))
		{
			return;
		}

		switch(string)
		{
			case Locale.HOT_KEYS:
				mn.ret();
				main.FileSelect.toggleHotKeyMode();
				break;

			case Locale.EXIT_CMD: // выход
				mn.ret();
				main.destroyApp();
				break;
			
			case Locale.MINIMIZE_CMD:
				mn.ret();
				try
				{
					main.dsp.setCurrent(null);
				}
				catch(Exception e)
				{
				}
				break;

			case Locale.MARK_CMD: // выделить
				main.FileSelect.markSelected();
				mn.ret();
				break;

			case Locale.MARK_ALL_CMD: // выделить все
				main.FileSelect.markAll();
				mn.ret();
				break;

			case Locale.DEMARK_ALL_CMD: // сбросить выделение
				main.FileSelect.demarkAll();
				mn.ret();
				break;

			case Locale.HELP_CMD: // справка
				cvsTextView.getInstance().openStream(Locale.getAboutStream(), Locale.ABOUT_MIDLET_NAME + "." + Locale.ABOUT_DEPLOYMENT_NUMBER);
				break;

			case Locale.TO_FAVOUR_CMD: // папку в избранное
				if("..".equals(main.currentFile))
				{
					options.addFavorite(main.currentPath);
				}
				else if(main.currentPath.length() > 0)
				{
					options.addFavorite(main.currentPath + main.currentFile);
				}
				else
				{
					options.addFavorite(main.currentFile.substring(0, 3));
				}

				main.dsp.setCurrent(mn.parent);
				break;

			case Locale.DISK_INFO_CMD: // инфо о диске
				main.dsp.setCurrent(new diskInfo(mn.parent));
				break;

			case Locale.PROPERTY_CMD: // свойства
				main.dsp.setCurrent(new frmProperties(mn.parent));
				break;

			case Locale.BUFFER: // показать буфер обмена
				main.FileSelect.showBuffer();
				break;

			case Locale.OPEN_CMD: // открыть
				mn.ret();
				main.FileSelect.selectFile();
				break;

			case Locale.MODULES_CMD:
				main.FileSelect.showModuleList();
				break;

			case Locale.MENU_ADDITIONAL:
				main.FileSelect.showOperationList();
				break;
			
			case Locale.CRYPT_CMD:
				main.dsp.setCurrent(new frmCrypt(mn.parent));
				break;
			
			case Locale.MENU_SEARCH:
				main.dsp.setCurrent(new frmSearch(mn.parent));
				break;

			case Locale.RENAME_CMD: // переименовать
				main.dsp.setCurrent(new frmRename(mn.parent));
				break;
			
			case Locale.DELETE_CMD: // удалить выбранный/выделенные
				if("fav:/".equals(main.currentPath)) // удаляем из избранного
				{
					if(main.FileSelect.getMarkCount() > 0)
					{
						Enumeration files = main.FileSelect.elements();
						FileItem item;
						
						while(files.hasMoreElements())
						{
							item = (FileItem)files.nextElement();
							
							if(item.isMarked())
							{
								options.deleteFavorite(item.getFullName());
							}
						}
					}
					else if(main.FileSelect.getSelectedIndex() > 0)
					{
						options.deleteFavorite(main.FileSelect.getFileItem(main.FileSelect.getSelectedIndex()).getFullName());
					}

					cvsWait.start(mn);
				}
				else if("buf:/".equals(main.currentPath)) // удаляем из буфера
				{
					if(main.FileSelect.getMarkCount() > 0)
					{
						Enumeration files = main.FileSelect.elements();
						FileItem item;
						
						while(files.hasMoreElements())
						{
							item = (FileItem)files.nextElement();
							
							if(item.isMarked())
							{
								Buffer.remove(item.getFullName());
							}
						}
					}
					else if(main.FileSelect.getSelectedIndex() > 0)
					{
						Buffer.remove(main.FileSelect.getFileItem(main.FileSelect.getSelectedIndex()).getFullName());
					}

					cvsWait.start(mn);
				}
				else
				{
					if(main.FileSelect.getMarkCount() <= 0) // удаляем просто немаркированный файл
					{
						main.dsp.setCurrent(new alConfirmDelete(main.currentPath + main.currentFile, mn.parent));
					}
					else
					{
						main.dsp.setCurrent(new alConfirmDeleteSel(mn.parent));
					}
				}

				break;

			case Locale.NEW_FOLDER_CMD: // создать папку
				main.dsp.setCurrent(new frmNewFolder(mn.parent));
				break;
			
			case Locale.NEW_FILE_CMD: // создать файл
				main.dsp.setCurrent(new frmNewFile(mn.parent, FileSource.TYPE_NORMAL_FILE));
				break;
			
			case Locale.MOVE_CMD: // переместить
				moveit = true;

			case Locale.EXTRACT_CMD:
			case Locale.EXTRACT_ALL_CMD:
				if(string == Locale.EXTRACT_ALL_CMD)
				{
					main.FileSelect.markAll();
				}
			
			case Locale.COPY_CMD: // копировать
				if(main.FileSelect.getMarkCount() <= 0) // копируем поодиночку
				{
					Buffer.add(main.FileSelect.getFileItem(main.FileSelect.getSelectedIndex()).getFullName(), moveit);
				}
				else // копируем выделенные в буфер
				{
					Enumeration files = main.FileSelect.elements();
					FileItem item;

					while(files.hasMoreElements())
					{
						item = (FileItem)files.nextElement();

						if(item.isMarked())
						{
							Buffer.add(item.getFullName(), moveit);
						}
					}

					main.FileSelect.demarkAll();
				}

				if("buf:/".equals(main.currentPath))
				{
					mn.ret();
				}
				else
				{
					main.showMessage(Locale.getString(this, Locale.DONE), Locale.getString(this, Locale.SELECT_PASTE_IN_FOLDER), AlertType.INFO, 1500, mn.parent);
				}
				break;

			case Locale.ADD_CMD:
			case Locale.INSERT_CMD: // вставить
				Buffer.startOperation(new CopyMoveThread(main.currentPath));
				break;
			
			case Locale.FAVOURITE: // показать избранное
				main.currentPath = "fav:/";
				cvsWait.start(mn);
				break;
			
			case Locale.PREFERENCES_CMD: // настройки
				Runnable runnable = new Runnable()
				{
					public void run()
					{
						if(!options.optionsPasswordHash.equals(options.EMPTY_HASH))
						{
							frmPassword pf = new frmPassword(Locale.getString(null, Locale.PASS_REQUEST_ON_OPTIONS), options.optionsPasswordHash);
							main.dsp.setCurrent(pf);

							if(!pf.modalResult())
							{
								return;
							}
						}
						
						main.dsp.setCurrent(new frmOptions(mn.parent));
					}
				};
				(new Thread(runnable)).start();
				break;
			
			case Locale.CREATE_ARCHIVE: // создать архив из файлов из буфера
				main.dsp.setCurrent(new frmNewFile(mn.parent, FileSource.TYPE_CONTAINER));
				break;
			
			case Locale.SELECT_CMD:
				mn.ret();
				main.FileSelect.fireSelectAction();
				break;
			
			case Locale.PREV_LINE_CMD:
			case Locale.NEXT_LINE_CMD:
			case Locale.PREV_SCREEN_CMD:
			case Locale.NEXT_SCREEN_CMD:
			case Locale.GOTO_START_CMD:
			case Locale.GOTO_END_CMD:
				mn.ret();
				main.FileSelect.directKeyPressed(string);
				break;
			
			case Locale.OPTIONS_CMD:
				main.FileSelect.showMenu();
				break;
			
			case Locale.FULLSCREEN_CMD:
				main.FileSelect.changeFSMode();
				mn.ret();
				break;
			
			case Locale.BACK_CMD:
				main.FileSelect.upDir();
				break;
			
			case Locale.KEYBOARD_CONFIG_CMD:
				main.showKeyConfig();
				break;
			
			case Locale.CLOCK_MODE:
				options.clockMode = !options.clockMode;
				main.FileSelect.repaint();
				break;
			
			case Locale.NEXT_PANEL:
				mn.ret();
				main.manager.showNextPanel();
				break;
			
			case Locale.PREV_PANEL:
				mn.ret();
				main.manager.showPrevPanel();
				break;
			
			case Locale.NEXT_FREE:
				mn.ret();
				main.manager.showNextFreePanel();
				break;
			
			case Locale.PREV_FREE:
				mn.ret();
				main.manager.showPrevFreePanel();
				break;
			
			case Locale.QUICK_SWITCH:
				mn.ret();
				main.manager.changePanel(main.manager.prevPanel());
				break;

			case Locale.PANELS:
				main.dsp.setCurrent(new lstPanels(mn.parent));
				break;
			
			case Locale.SORT_REVERSE_ORDER:
				options.listSortReverseOrder = !options.listSortReverseOrder;
				main.FileSelect.showWait(main.currentFile);
				break;
			
			case Locale.IGNORE_CASE:
				options.listSortIgnoreCase = !options.listSortIgnoreCase;
				main.FileSelect.showWait(main.currentFile);
				break;
			
			case Locale.MEMORY_MONITOR:
				main.monitor.show(mn.parent);
				break;

			case Locale.CONTAINERS:
				main.showContainerList(mn.parent);
				break;

			case Locale.COLOR_SCHEME:
				options.colorScheme = ColorScheme.SCHEME_CUSTOM;
				main.showColorSchemeEditor(mn.parent);
				break;
		}
	}
}
