package filemanager; // переведен

import com.vmx.Locale;
import javax.microedition.lcdui.*;

public class alConfirmDelete extends GraphicAlert implements CommandListener
{
	Command cmdYes = new Command(Locale.getString(this, Locale.YES_CMD), Command.OK, 1);
	Command cmdNo = new Command(Locale.getString(this, Locale.NO_CMD), Command.CANCEL, 2);

	//public static boolean yes = false;
	Object parent;
	String fn;
	boolean tryrec;

	public alConfirmDelete(String fileName, Object parent)
	{
		super("", "", images.getAlertIcon(AlertType.CONFIRMATION), AlertType.CONFIRMATION);
		
		setTitle(Locale.getString(this, Locale.CONFIRMATION));
		setText(Locale.getString(this, Locale.DEL_SELECTED_FILE));

		this.parent = parent;
		this.fn = fileName;
		this.tryrec = false;
		
		addCommand(cmdYes);
		addCommand(cmdNo);
		
		setCommandListener(this);
	}

	public void commandAction(Command command, Displayable displayable)
	{
		if(command == cmdYes)
		{
			setType(AlertType.INFO);
			setImage(images.getAlertIcon(AlertType.INFO));
			setTitle(Locale.getString(this, Locale.WAIT));
			setString(Locale.getString(this, Locale.WAIT_PLEASE));
			setTimeout(Alert.FOREVER);
			removeCommand(cmdYes);
			removeCommand(cmdNo);
			main.dsp.setCurrent(this, parent);
			
			if(filesystem.isDir(fn)) // это папка
			{
				if(filesystem.isReadOnly(fn))
				{
					// файл только для чтения
					main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.FILE_READ_ONLY, fn), AlertType.WARNING, 3000, parent);
				}
				else if(filesystem.deleteFile(fn, tryrec, this))
				{
					// файл удален
					
					main.FileSelect.delete(main.FileSelect.getSelectedIndex());

					main.showMessage(Locale.getString(this, Locale.DONE), Locale.getString(this, Locale.FOLDER_DELETED), AlertType.INFO, 1500, parent);
				}
				else
				{
					// не получилось удалить...
					
					if(tryrec)
					{
						// рекурсивно уже пробовали,
						// все равно не вышло по неизвестным причинам

						main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.FILE_NOT_DELETED, fn), AlertType.ERROR, 3000, parent);
					}
					else
					{
						// может быть получится рекурсивно
						
						setType(AlertType.CONFIRMATION);
						setImage(images.getAlertIcon(AlertType.CONFIRMATION));
						setTitle(Locale.getString(this, Locale.CONFIRMATION));
						setString(Locale.getString(this, Locale.FOLDER_NOT_EMPTY));
						setTimeout(Alert.FOREVER);
						addCommand(cmdYes);
						addCommand(cmdNo);
						tryrec = true;
						main.dsp.setCurrent(this, parent);
					}
				}
			}
			else // это файл
			{
				if(filesystem.isReadOnly(fn))
				{
					// файл только для чтения

					main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.FILE_READ_ONLY, fn), AlertType.WARNING, 3000, parent);
				}
				else if(filesystem.deleteFile(fn, false, this))
				{
					// файл удален
					
					main.FileSelect.delete(main.FileSelect.getSelectedIndex());
					main.showMessage(Locale.getString(this, Locale.DONE), Locale.getString(this, Locale.FILE_DELETED), AlertType.INFO, 1500, parent);
				}
				else
				{
					// файл не удален неивестно почему

					main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.FILE_NOT_DELETED, fn), AlertType.ERROR, 3000, parent);
				}
			}
		}
		else
		{
			main.dsp.setCurrent(parent);
		}
	}
}
