package filemanager; // переведен

import com.vmx.Locale;
import javax.microedition.lcdui.*;
import java.util.Enumeration;

public class alConfirmDeleteSel extends GraphicAlert implements CommandListener
{
	Command cmdYes = new Command(Locale.getString(this, Locale.YES_CMD), Command.OK, 1);
	Command cmdNo = new Command(Locale.getString(this, Locale.NO_CMD), Command.CANCEL, 2);

	Object parent;
	String fileFullName, fileOnlyName;
	StringBuffer errors = new StringBuffer();

	public alConfirmDeleteSel(Object parent)
	{
		super("", "", images.getAlertIcon(AlertType.CONFIRMATION), AlertType.CONFIRMATION);

		setTitle(Locale.getString(this, Locale.CONFIRMATION));
		setText(Locale.getString(this, Locale.DEL_MARKED_FILES));

		this.parent = parent;

		addCommand(cmdYes);
		addCommand(cmdNo);

		setCommandListener(this);
	}

	public void commandAction(Command command, Displayable displayable)
	{
		if(command == cmdYes)
		{
			setType(AlertType.WARNING);
			setTitle(Locale.getString(this, Locale.WAIT));
			setString(Locale.getString(this, Locale.WAIT_PLEASE));
			setImage(null);
			setTimeout(Alert.FOREVER);
			removeCommand(cmdYes);
			removeCommand(cmdNo);
			main.dsp.setCurrent(this, parent);
			
			Enumeration files = main.FileSelect.elements();
			FileItem item;
			
			while(files.hasMoreElements())
			{
				item = (FileItem)files.nextElement();
				
				if(item.isSpecial() || !item.isMarked())
				{
					continue;
				}
				
				if(item.isReadOnly())
				{
					// файл только для чтения
					errors.append(Locale.getString(this, Locale.FILE_READ_ONLY, item.getName()));
					errors.append("\n\n");
				}
				else if(!filesystem.deleteFile(item.getFullName(), true, this))
				{
					// файл не удален неизвестно почему
					errors.append(Locale.getString(this, Locale.FILE_NOT_DELETED, item.getName()));
					errors.append("\n\n");
				}
			}

			main.dsp.setCurrent(new alMessage(errors.toString()));
		}
		else if(command == cmdNo)
		{
			main.dsp.setCurrent(parent);
		}
	}
}
