package filemanager;

import com.vmx.Locale;
import javax.microedition.lcdui.*;

/**
 * Класс для выдачи сообщения типа "Файл ... существует. Перезаписать?"
 * с вариантами ответа Да / Нет / Да для всех / Нет для всех / Отмена
 */
public class alConfirmOverwrite extends GraphicAlert implements CommandListener, Runnable
{
	public Command cmdYes = new Command(Locale.getString(this, Locale.YES_CMD), Command.OK, 1);
	public Command cmdNo = new Command(Locale.getString(this, Locale.NO_CMD), Command.CANCEL, 2);
	public Command cmdYesForAll = new Command(Locale.getString(this, Locale.YES_FOR_ALL), Command.OK, 3);
	public Command cmdNoForAll = new Command(Locale.getString(this, Locale.NO_FOR_ALL), Command.CANCEL, 4);
	public Command cmdCancel = new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.BACK, 5);
	
	public Command modalResult;
	public Thread t;

	private Object nextShow;
	private final Object waiter;
	
	/**
	 * Конструирует класс и создаёт поток, ожидающий выбора команды.
	 * А Buffer юзает al.t.join() для того, чтобы подождать.
	 */
	public alConfirmOverwrite(String filename, Object nextDsp)
	{
		super("", "", images.getAlertIcon(AlertType.CONFIRMATION), AlertType.CONFIRMATION);
		
		setTitle(Locale.getString(this, Locale.CONFIRMATION));
		setText(Locale.getString(this, Locale.NAME_EXIST_OVERWRITE_QUESTION, filename));

		addCommand(cmdYes);
		addCommand(cmdNo);
		addCommand(cmdYesForAll);
		addCommand(cmdNoForAll);
		addCommand(cmdCancel);

		setCommandListener(this);

		setTimeout(Alert.FOREVER);
		
		nextShow = nextDsp;
		waiter = new Object();

		t = new Thread(this, "ConfirmOverwrite/ModalWait");
	}
	
	/**
	 * Функция ожидания выбора команды
	 */
	public void run()
	{
		try
		{
			synchronized(waiter)
			{
				waiter.wait();
			}
		}
		catch(InterruptedException ie)
		{
		}
		
		main.dsp.setCurrent(nextShow);
	}
	
	/**
     * Обработка команды - прерывает поток выполнения и задаёт modalResult
     */
	public void commandAction(Command c, Displayable d)
	{
		modalResult = c;

		synchronized(waiter)
		{
			waiter.notifyAll();
		}
	}
}
