package filemanager; // переведен

import com.vmx.Locale;
import javax.microedition.lcdui.*;

public class alMessage extends GraphicAlert implements Runnable, CommandListener
{
	private Thread t;
	private boolean ok;

	public alMessage(String text)
	{
		super("", "", null, null);
		
		if(text == null || text.length() == 0) // копирование переименование удаление без ошибок
		{
			setType(AlertType.INFO);
			setImage(images.getAlertIcon(AlertType.INFO));
			setTitle(Locale.getString(this, Locale.DONE));
			setString(Locale.getString(this, Locale.OPERATION_OK));
			
			ok = true;
		}
		else
		{
			setType(AlertType.ERROR);
			setImage(images.getAlertIcon(AlertType.ERROR));
			setTitle(Locale.getString(this, Locale.ERROR));
			setString(text);
			
			ok = false;
		}
		
		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		setCommandListener(this);
		
		t = new Thread(this, "Message/Delay");
		t.start();
	}

	public void run()
	{
		if(ok)
		{
			try
			{
				Thread.sleep(1500);
			}
			catch(InterruptedException ie)
			{
			}
			
			main.FileSelect.showWait(main.currentFile); // переход
		}
	}

	public void commandAction(Command command, Displayable displayable)
	{
		if(command.getCommandType() == Command.OK)
		{
			t.interrupt(); // прерываем таймер выше, там будет переход
			
			if(!ok)
			{
				main.FileSelect.showWait(main.currentFile);
			}
		}
	}
}
