package filemanager;

import com.one.AbstractFont;
import com.one.ExtGraphics;
import com.one.ModuleRegistry;
import com.one.PaintableObject;
import com.one.file.TransparentConnector;
import javax.microedition.lcdui.*;
import com.vmx.*;

public class cvsMenu extends gkcCanvas
{
	public Object parent;
	
	public MenuListener listen;
	
	protected int type, w, h;
	protected int sel1, sel2;
	protected int m2l;
	
	protected int[] menu_width; // width для различных (под)меню
	protected int[] menu_height; // height для различных (под)меню
	
	protected int mw1, mw2, mh1, mh2; // width & height для меню и подменю
	protected int mx1, mx2, my1, my2; // положение меню и подменю
	
	protected AbstractFont mf; // шрифт меню
	protected int mfh; // высота шрифта
	protected int mlh; // высота строки меню
	//protected FontWidthCache mfwc; // кэш ширины шрифта %)))
	protected Image drap;

	public boolean enabled[][];

	public static final int MENU_GENERIC = 0;
	public static final int MENU_SELECT_ACTION = 0x100;

//	public static final int MENU_DISK_SELECTED = 0, MENU_FILE_SELECTED = 1,
//			MENU_FOLDER_SELECTED = 2, MENU_DOTDOT_SELECTED = 3,
//			MENU_FAVORITES_SELECTED = 4, MENU_INSIDE_ARCHIVE = 5,
//			MENU_BUFFER_SELECTED = 6, MENU_BUCKET_SELECTED = 7,
//			MENU_SELECT_ACTION = 0x100;

	/** Конструктор */
	public cvsMenu()
	{
		int i, j, tt;
		int add = 0;
		
		listen = null;
		parent = null;
		type = -1;
		sel1 = 0;
		sel2 = -1;
		
		setFullScreenMode(true);
		
		w = getWidth();
		h = getHeight();

		//drap = LineEffect.createDrap(Colors.colors[Colors.drap], w, h);
		
		menu_length = menu_length_fix;
		
		mf = AbstractFont.getFont(AbstractFont.FACE_SYSTEM, AbstractFont.STYLE_PLAIN, options.largeFontInMenu ? AbstractFont.SIZE_MEDIUM : AbstractFont.SIZE_SMALL);
		mfh = mf.getHeight() + 1;
		
		mlh = Math.max(images.iconHeight + 1, mfh);
		
		if(options.showMenuNum)
		{
			add = mf.stringWidth("W0");
		}
		
		int add1 = mf.stringWidth(" >W");
		
		menu_width = new int[menu.length + 2]; // ширина для каждого подменю + две ширины основного
		menu_height = new int[menu.length + 2]; // то же самое, только для высоты
		
		// Подсчёт требуемой ширины и высоты меню ...
		
		for(mw1 = 0, i = 0; i < menu_length_fix; i++)
		{
			tt = mf.stringWidth(Locale.getString(this, menu[i][0])) + add1;
			
			if(i < 10)
			{
				tt += add;
			}
			
			if(tt > mw1)
			{
				mw1 = tt;
			}
		}
		
		menu_width[0] = mw1 + 4; // по 1 на рамку + по 1 отступ
		menu_height[0] = mlh * menu_length_fix + 3; // по 1 на рамку + 1 отступ сверху, отступ снизу учтен в mfh
		
		for(; i < menu.length; i++)
		{
			tt = mf.stringWidth(Locale.getString(this, menu[i][0])) + add1;
			
			if(i < 10)
			{
				tt += add;
			}
			
			if(tt > mw1)
			{
				mw1 = tt;
			}
		}
		
		menu_width[1] = mw1 + 4;
		menu_height[1] = mlh * menu.length + 3;
		
		// ... и подменю
		
		for(i = 0; i < menu.length; i++)
		{
			m2l = (menu[i].length - 1) / 2;
			
			for(mw2 = 0, j = 0; j < m2l; j++)
			{
				tt = mf.stringWidth(Locale.getString(this, menu[i][1 + j * 2]));
				
				if(j < 10)
				{
					tt += add;
				}
				
				if(tt > mw2)
				{
					mw2 = tt;
				}
			}
			
			menu_width[i + 2] = mw2	+ images.iconWidth + 5; // по 1 на рамку + по 1 на отступ + 1 между значком и текстом
			menu_height[i + 2] = mlh * m2l + 3;
		}
		
		// а также создаём и заполняем enabled
		enabled = new boolean[menu.length][];
		
		for(i = 0; i < menu.length; i++)
		{
			enabled[i] = new boolean[1 + (menu[i].length - 1) / 2];
			
			for(j = 0; j < 1 + (menu[i].length - 1) / 2; j++)
			{
				enabled[i][j] = true;
			}
		}
		
		listen = new WorkingMenu(this);
	}
	
	/** 
	 * Смена типа меню (затемнение ненужных элементов)
	 */
	public void setType(int type)
	{
		this.type = type;
		sel1 = 0;
		sel2 = -1;
		
		if(type == MENU_GENERIC) // >= MENU_DISK_SELECTED && type <= MENU_BUCKET_SELECTED)
		{
			if(options.useFullMenu)
			{
				menu_length = menu.length;
				
				mw1 = menu_width[1];
				mh1 = menu_height[1];
				mx1 = 7;
				my1 = h - menu_height[1] - 7;
			}
			else
			{
				menu_length = menu_length_fix;
				
				mw1 = menu_width[0];
				mh1 = menu_height[0];
				mx1 = 7;
				my1 = h - menu_height[0] - 7;
			}
			
			for(int i = 0; i < menu_length_fix; i++)
			{
				System.arraycopy(enabledModes[type][i], 0, enabled[i], 0, enabledModes[type][i].length);
			}

			boolean inroot = main.currentPath.length() == 0;

			boolean inbuf = "buf:/".equals(main.currentPath);
			boolean infav = "fav:/".equals(main.currentPath) ||
							"null:/".equals(main.currentPath);

			boolean dotsel = "..".equals(main.currentFile);
			boolean favsel = Locale.getString(this, Locale.FAVOURITE).equals(main.currentFile) ||
							 Locale.getString(this, Locale.BIT_BUCKET).equals(main.currentFile);

			boolean hasbuf = Buffer.getSize() > 0;

			if(inroot)
			{
				enabled[0][3] = false;
				enabled[0][4] = false;
				enabled[0][5] = false;
			}

			if(inroot || infav || inbuf)
			{
				enabled[0][2] = false;
				enabled[0][6] = false;

				enabled[2][1] = false;
			}
			else
			{
				enabled[3][1] = hasbuf;
			}
			
			if(inroot || infav || inbuf || dotsel)
			{
				enabled[3][2] = inbuf && hasbuf;
				enabled[3][3] = inbuf && hasbuf;
				enabled[3][4] = infav || (inbuf && hasbuf);
				enabled[3][5] = false;
			}

			if(infav || favsel || inbuf)
			{
				enabled[3][6] = inbuf && hasbuf;
			}

			if(TransparentConnector.isPathInContainer(main.currentPath))
			{
				enabled[1][1] = true;
				enabled[1][2] = true;
				enabled[1][3] = enabled[3][1];
			}
			
			enabled[5][1] = hasbuf;
			enabled[0][2] = !filesystem.isDir(main.currentFile);
			
			for(int i = 0; i < enabled.length; i++)
			{
				for(int j = 1; j < enabled[i].length; j++)
				{
					if(enabled[i][j])
					{
						enabled[i][0] = true;
						break;
					}
				}
			}

			if(inroot || infav || inbuf)
			{
				enabled[4][0] = false;
			}

			if(infav || favsel || inbuf)
			{
				enabled[2][0] = false;
			}

			enabled[5][3] = AuxClass.classExists(main.TEXT_VIEW_CLASS);
		}
		else
		{
			menu_length = menu.length;
			
			mw1 = menu_width[1];
			mh1 = menu_height[1];
			mx1 = 7;
			my1 = h - menu_height[1] - 7;
			
			for(int i = 0; i < menu.length; i++)
			{
				for(int j = 0; j < 1 + (menu[i].length - 1) / 2; j++)
				{
					enabled[i][j] = true;
				}
			}
		}
	}

	public boolean isActionAllowed(int action)
	{
		for(int i = 0; i < menu.length; i++)
		{
			for(int j = 1; j < menu[i].length; j += 2)
			{
				if(menu[i][j] == action)
				{
					return enabled[i][(j - 1) / 2 + 1];
				}
			}
		}

		return true;
	}
	
	/** функция отрисовки */
	public void paint(ExtGraphics g)
	{
		if(parent instanceof PaintableObject)
		{
			((PaintableObject)parent).paint(g);
		}
		else
		{
			images.drawVGradient(g, ColorScheme.colors[ColorScheme.mnback1], ColorScheme.colors[ColorScheme.mnback2], 0, 0, w, h, options.ditherGradients);
		}

		g.setClip(0, 0, w, h);
		
		if(sel2 < 0 && drap != null)
		{
			g.drawImage(drap, 0, 0, Graphics.LEFT | Graphics.TOP);
		}

		if(my1 + sel1 * mlh < 0)
		{
			my1 = -sel1 * mlh;
		}
		else if(my1 + (sel1 + 1) * mlh > h - 3)
		{
			my1 = h - (sel1 + 1) * mlh - 3;
		}
		
		g.setColor(ColorScheme.colors[ColorScheme.mnback1]);
		
		images.drawVGradient(g, ColorScheme.colors[ColorScheme.mnback1], ColorScheme.colors[ColorScheme.mnback2], mx1, my1, mw1, mh1, options.ditherGradients);

		g.setColor(ColorScheme.colors[ColorScheme.dkborder]);
		g.drawRect(mx1, my1, mw1 - 1, mh1 - 1);
		g.setFont(mf);

		// Отрисовка меню
		for(int i = 0; i < menu_length; i++)
		{
			if(enabled[i][0])
			{
				if(i == sel1)
				{
					g.setColor(ColorScheme.colors[ColorScheme.mnselback1]);
					
					if(options.frameCursor)
					{
						g.drawRect(mx1 + 1, my1 + 1 + i * mlh, mw1 - 3, mlh);
					}
					else
					{
						images.drawHGradient(g, ColorScheme.colors[ColorScheme.mnselback1], ColorScheme.colors[ColorScheme.mnselback2], mx1 + 1, my1 + 1 + i * mlh, mw1 - 2, mlh + 1, options.ditherGradients);
					}
					
					g.setColor(ColorScheme.colors[ColorScheme.mnselfore]);
					g.drawString(Locale.getString(this, menu[i][0]) + " >", mx1 + 2, my1 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.LEFT | Graphics.TOP);
				}
				else
				{
					g.setColor(ColorScheme.colors[ColorScheme.mnfore]);
					g.drawString(Locale.getString(this, menu[i][0]) + " >", mx1 + 2, my1 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.LEFT | Graphics.TOP);
					g.setColor(ColorScheme.colors[ColorScheme.mnaltfore]);
				}
			}
			else
			{
				g.setColor(ColorScheme.colors[ColorScheme.disabled]);
				g.drawString(Locale.getString(this, menu[i][0]) + " >", mx1 + 2, my1 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.LEFT | Graphics.TOP);
			}
			
			if(options.showMenuNum)
			{
				if(i < 9)
				{
					g.drawChar((char)(KEY_NUM1 + i), mx1 + mw1 - 2, my1 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.RIGHT | Graphics.TOP);
				}
				else if(i == 9)
				{
					g.drawChar((char)KEY_NUM0, mx1 + mw1 - 2, my1 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.RIGHT | Graphics.TOP);
				}
			}
		}
		
		// Если отображено подменю - рисуем его
		if(sel2 >= 0)
		{
			if(drap != null)
			{
				g.drawImage(drap, 0, 0, Graphics.LEFT | Graphics.TOP);
			}

			if(my2 + sel2 * mlh < 0)
			{
				my2 = -sel2 * mlh;
			}
			else if(my2 + (sel2 + 1) * mlh > h - 3)
			{
				my2 = h - (sel2 + 1) * mlh - 3;
			}
			
			g.setColor(ColorScheme.colors[ColorScheme.mnback1]);
			
			images.drawVGradient(g, ColorScheme.colors[ColorScheme.mnback1], ColorScheme.colors[ColorScheme.mnback2], mx2, my2, mw2, mh2, options.ditherGradients);
			
			g.setColor(ColorScheme.colors[ColorScheme.dkborder]);
			g.drawRect(mx2, my2, mw2 - 1, mh2 - 1);

			int string;
			String text;
			Image icon;

			int maxw = mf.stringWidth(Locale.getString(this, Locale.FAV_MOD_NUMS + 9));
			
			for(int i = 0; i < m2l; i++)
			{
				string = menu[sel1][i * 2 + 1];

				if(string >= Locale.FAV_MOD_NUMS && string < Locale.FAV_MOD_NUMS + 10 &&
				   options.favmodules[string - Locale.FAV_MOD_NUMS].length() > 0)
				{
					text = mf.getLastPartOfString(ModuleRegistry.getModuleName(options.favmodules[string - Locale.FAV_MOD_NUMS]), "...", maxw, false);
					icon = ModuleRegistry.getIcon(options.favmodules[string - Locale.FAV_MOD_NUMS]);
				}
				else
				{
					text = Locale.getString(this, string);
					icon = images.getIcon(menu[sel1][i * 2 + 2]);
				}

				if(enabled[sel1][i + 1])
				{
					if(i == sel2)
					{
						g.setColor(ColorScheme.colors[ColorScheme.mnselback1]);
						
						if(options.frameCursor)
						{
							g.drawRect(mx2 + 1, my2 + 1 + i * mlh, mw2 - 3, mlh);
						}
						else
						{
							images.drawHGradient(g, ColorScheme.colors[ColorScheme.mnselback1], ColorScheme.colors[ColorScheme.mnselback2], mx2 + 1, my2 + 1 + i * mlh, mw2 - 2, mlh + 1, options.ditherGradients);
						}
						
						g.setColor(ColorScheme.colors[ColorScheme.mnselfore]);
						g.drawString(text, mx2 + images.iconWidth + 3, my2 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.LEFT | Graphics.TOP);
					}
					else
					{
						g.setColor(ColorScheme.colors[ColorScheme.mnfore]);
						g.drawString(text, mx2 + images.iconWidth + 3, my2 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.LEFT | Graphics.TOP);
						g.setColor(ColorScheme.colors[ColorScheme.mnaltfore]);
					}
				}
				else
				{
					g.setColor(ColorScheme.colors[ColorScheme.disabled]);
					g.drawString(text, mx2 + images.iconWidth + 3, my2 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.LEFT | Graphics.TOP);
				}

				if(icon != null)
				{
					g.drawImage(icon, mx2 + 2, my2 + 2 + i * mlh + (mlh - images.iconHeight) / 2, Graphics.LEFT | Graphics.TOP);
				}
				
				if(options.showMenuNum)
				{
					if(i < 9)
					{
						g.drawChar((char)(KEY_NUM1 + i), mx2 + mw2 - 2, my2 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.RIGHT | Graphics.TOP);
					}
					else if(i == 9)
					{
						g.drawChar((char)KEY_NUM0, mx2 + mw2 - 2, my2 + 2 + i * mlh + (mlh - mfh) / 2, Graphics.RIGHT | Graphics.TOP);
					}
				}
			}
		}
	}
	
	/** Функция возвращения к предыдущему экрану (к parent) */
	public void ret()
	{
		if(parent != null)
		{
			if(main.dsp.getCurrent() != parent)
			{
				main.dsp.setCurrent(parent);
			}
			
			parent = null;
		}
	}
	
	/** Обработчик нажатий клавиш */
	public void keyPressed(int keyCode)
	{
		keyCode = remapKey(keyCode);
		
		int osel, ml;
		
		if(!options.showMenuNum)
		{
			keyCode = translateKey(keyCode);
		}
		
		if(options.swapSoftKeys)
		{
			if(keyCode == KEY_LSK)
			{
				keyCode = KEY_RSK;
			}
			else if(keyCode == KEY_RSK)
			{
				keyCode = KEY_LSK;
			}
		}
		
		if(keyCode == KEY_DOWN)
		{
			if(sel2 == -1) // гуляем по меню
			{
				osel = sel1;
				ml = menu_length;
				
				do
				{
					sel1 = (sel1 + 1) % ml;
				}
				while(!enabled[sel1][0] && sel2 != osel);
			}
			else // гуляем по подменю
			{
				osel = sel2;
				ml = (menu[sel1].length - 1) / 2;
				
				do
				{
					sel2 = (sel2 + 1) % ml;
				}
				while(!enabled[sel1][1 + sel2] && sel2 != osel);
			}
			
			repaint();
		}
		else if(keyCode == KEY_UP)
		{
			if(sel2 == -1) // гуляем по меню
			{
				osel = sel1;
				ml = menu_length;
				
				do
				{
					sel1 = (sel1 - 1 + ml) % ml;
				}
				while(!enabled[sel1][0] && sel2 != osel);
			}
			else // гуляем по подменю
			{
				osel = sel2;
				ml = (menu[sel1].length - 1) / 2;
				
				do
				{
					sel2 = (sel2 - 1 + ml) % ml;
				}
				while(!enabled[sel1][1 + sel2] && sel2 != osel);
			}
			
			repaint();
		}
		else if(keyCode == KEY_LSK ||
		        keyCode == KEY_LEFT ||
		        keyCode == KEY_CANCEL)
		{
			if(sel2 == -1)
			{
				ret();
			}
			else
			{
				sel2 = -1;
				repaint();
			}
		}
		else if(keyCode == KEY_FIRE ||
		        keyCode == KEY_RIGHT ||
			    keyCode == KEY_RSK ||
			    keyCode == KEY_DIAL)
		{
			if(sel2 == -1)
			{
				sel2 = 0;
				
				while(!enabled[sel1][1 + sel2])
				{
					sel2++;
				}
				
				m2l = (menu[sel1].length - 1) / 2;
				
				mw2 = menu_width[sel1 + 2];
				mh2 = menu_height[sel1 + 2];
				
				mx2 = 14;
				my2 = my1 + 2 + sel1 * mlh + mlh / 2;
				
				if(my2 + mh2 > h - 14)
				{
					my2 = h - mh2 - 14;
				}
				
				repaint();
			}
			else if(listen != null)
			{
				listen.menuAction(menu[sel1][1 + sel2 * 2]);
			}
		}
		else if((keyCode >= KEY_NUM1 && keyCode <= KEY_NUM9) || keyCode == KEY_NUM0)
		{
			if(!options.showMenuNum)
			{
				return;
			}
			
			if(keyCode == KEY_NUM0)
			{
				keyCode = 9;
			}
			else
			{
				keyCode -= KEY_NUM1;
			}
			
			try
			{
				if(sel2 < 0)
				{
					if(enabled[keyCode][0])
					{
						sel1 = keyCode;
						keyPressed(KEY_FIRE);
					}
				}
				else
				{
					if(enabled[sel1][1 + keyCode])
					{
						sel2 = keyCode;
						keyPressed(KEY_FIRE);
					}
				}
			}
			catch(ArrayIndexOutOfBoundsException e)
			{
			}
		}
	}
	
	/**
	 * Обработчик повторений клавиш
	 */
//	protected void keyRepeated(int keyCode)
//	{
//		if(keyCode == KEY_DOWN || keyCode == KEY_UP)
//		{
//			keyPressed(keyCode);
//		}
//	}
	
	/** Данные меню */
	static final int menu[][] =
	{
		{
			Locale.MENU_FILE,
			Locale.OPEN_CMD, images.iNext,
			Locale.MODULES_CMD, images.iNext,
			Locale.MARK_CMD, images.iMark,
			Locale.MARK_ALL_CMD, images.iMarkAll,
			Locale.DEMARK_ALL_CMD, images.iDemarkAll,
			Locale.MENU_SEARCH, images.iSearch
		},
		{
			Locale.MENU_ARCHIVE,
			Locale.EXTRACT_CMD, images.iUnpack,
			Locale.EXTRACT_ALL_CMD, images.iUnpack,
			Locale.ADD_CMD, images.iPack
		},
		{
			Locale.MENU_PROPERTIES,
			Locale.PROPERTY_CMD, images.iProperties,
			Locale.DISK_INFO_CMD, images.iDisk
		},
		{
			Locale.MENU_OPERATIONS,
			Locale.INSERT_CMD, images.iPaste,
			Locale.COPY_CMD, images.iCopy,
			Locale.MOVE_CMD, images.iMove,
			Locale.DELETE_CMD, images.iDelete,
			Locale.RENAME_CMD, images.iRename,
			Locale.TO_FAVOUR_CMD, images.iFavorites,
			Locale.MENU_ADDITIONAL, images.iClipboard
		},
		{
			Locale.MENU_CREATE,
			Locale.NEW_FILE_CMD, images.iFile,
			Locale.NEW_FOLDER_CMD, images.iFolder,
			Locale.CREATE_ARCHIVE, images.iPack,
		},
		{
			Locale.MENU_SHOW,
			Locale.BUFFER, images.iClipboard,
			Locale.FAVOURITE, images.iFavorites,
			Locale.HELP_CMD, images.iHelp,
			Locale.PREFERENCES_CMD, images.iOptions,
			Locale.KEYBOARD_CONFIG_CMD, images.iKey,
			Locale.MINIMIZE_CMD, images.iMinimize,
			Locale.EXIT_CMD, images.iExit
		},
		{
			Locale.MENU_ADDITIONAL,
			Locale.KEY_NO_ACTION, images.iMoveIt,
			Locale.OPTIONS_CMD, images.iMenu,
			Locale.SELECT_CMD, images.iSelect,
			Locale.PREV_LINE_CMD, -1,
			Locale.NEXT_LINE_CMD, -1,
			Locale.PREV_SCREEN_CMD, -1,
			Locale.NEXT_SCREEN_CMD, -1,
			Locale.GOTO_START_CMD, -1,
			Locale.GOTO_END_CMD, -1,
			Locale.CLOCK_MODE, -1,
			Locale.FULLSCREEN_CMD, -1,
			Locale.BACK_CMD, -1,
			Locale.HOT_KEYS, -1
		},
		{
			Locale.PANELS,
			Locale.PANEL_NUMS+0, -1,
			Locale.PANEL_NUMS+1, -1,
			Locale.PANEL_NUMS+2, -1,
			Locale.PANEL_NUMS+3, -1,
			Locale.PANEL_NUMS+4, -1,
			Locale.PANEL_NUMS+5, -1,
			Locale.PANEL_NUMS+6, -1,
			Locale.PANEL_NUMS+7, -1,
			Locale.PANEL_NUMS+8, -1,
			Locale.PANEL_NUMS+9, -1
		},
		{
			Locale.SWITCH,
			Locale.NEXT_PANEL, -1,
			Locale.PREV_PANEL, -1,
			Locale.NEXT_FREE, -1,
			Locale.PREV_FREE, -1,
			Locale.QUICK_SWITCH, -1,
			Locale.MEMORY_MONITOR, -1,
			Locale.CONTAINERS, -1,
			Locale.COLOR_SCHEME, -1,
			Locale.PANELS, -1
		},
		{
			Locale.MENU_LIST_SORT,
			Locale.SORT_NONE, -1,
			Locale.SORT_BY_NAME, -1,
			Locale.SORT_BY_TYPE, -1,
			Locale.SORT_BY_DATE, -1,
			Locale.SORT_BY_SIZE, -1,
			Locale.SORT_REVERSE_ORDER, -1,
			Locale.IGNORE_CASE, -1
		},
		{
			Locale.MENU_FAV_MODULES,
			Locale.FAV_MOD_NUMS+0, -1,
			Locale.FAV_MOD_NUMS+1, -1,
			Locale.FAV_MOD_NUMS+2, -1,
			Locale.FAV_MOD_NUMS+3, -1,
			Locale.FAV_MOD_NUMS+4, -1,
			Locale.FAV_MOD_NUMS+5, -1,
			Locale.FAV_MOD_NUMS+6, -1,
			Locale.FAV_MOD_NUMS+7, -1,
			Locale.FAV_MOD_NUMS+8, -1,
			Locale.FAV_MOD_NUMS+9, -1,
		},
		{
			Locale.MENU_KEY_REMAP,
			Locale.KEY_NUM1+0, -1,
			Locale.KEY_NUM1+1, -1,
			Locale.KEY_NUM1+2, -1,
			Locale.KEY_NUM1+3, -1,
			Locale.KEY_NUM1+4, -1,
			Locale.KEY_NUM1+5, -1,
			Locale.KEY_NUM1+6, -1,
			Locale.KEY_NUM1+7, -1,
			Locale.KEY_NUM1+8, -1,
			Locale.KEY_NUM1+9, -1,
			Locale.KEY_STAR, -1,
			Locale.KEY_POUND, -1
		}
	};
	
	static int menu_length = 6;
	static final int menu_length_fix = 6;
	
	/* Данные enabled режимов меню */
	static final boolean enabledModes[][][] =
	{
		{ // общая конфигурация
			{ false, true, true, true, true, true, true },
			{ false, false, false, false },
			{ false, true, true },
			{ false, false, true, true, true, true, true, true },
			{ false, true, true, true },
			{ false, false, true, true, true, true, true, true }
		}
//		{ // выбран диск
//			{ false, true, false, false, false, false, false },
//			{ false, false, false, false },
//			{ false, false, true },
//			{ false, false, false, false, false, false, true, true },
//			{ false, false, false, false },
//			{ false, false, true, true, true, true, true, true }
//		},
//		{ // выбран файл
//			{ false, true, true, true, true, true, true },
//			{ false, false, false, false },
//			{ false, true, true },
//			{ false, false, true, true, true, true, false, true },
//			{ false, true, true, true },
//			{ false, false, true, true, true, true, true, true }
//		},
//		{ // выбрана папка
//			{ false, true, false, true, true, true, true },
//			{ false, false, false, false },
//			{ false, true, true },
//			{ false, false, true, true, true, true, true, true },
//			{ false, true, true, true },
//			{ false, false, true, true, true, true, true, true }
//		},
//		{ // выбрано ..
//			{ false, true, false, false, true, true, true },
//			{ false, false, false, false },
//			{ false, true, true },
//			{ false, false, false, false, false, false, true, true },
//			{ false, true, true, true },
//			{ false, false, true, true, true, true, true, true }
//		},
//		{ // находимся в избранном
//			{ false, true, false, true, true, true, false },
//			{ false, false, false, false },
//			{ false, true, false },
//			{ false, false, false, false, true, false, false, true },
//			{ false, false, false, false },
//			{ false, false, true, true, true, true, true, true }
//		},
//		{ // находимся в архиве
//			{ false, true, false, true, true, true, true },
//			{ false, true, true, false },
//			{ false, true, true },
//			{ false, false, true, true, true, true, true, true },
//			{ false, true, true, true },
//			{ false, false, true, true, true, true, true, true }
//		},
//		{ // находимся в буфере обмена
//			{ false, true, false, true, true, true, false },
//			{ false, false, false, false },
//			{ false, false, false },
//			{ false, false, true, true, true, false, false, true },
//			{ false, false, false, false },
//			{ false, false, true, true, true, true, true, true }
//		},
//		{ // находимся в корзине
//			{ false, true, false, false, false, false, false },
//			{ false, false, false, false },
//			{ false, false, false },
//			{ false, false, false, false, false, false, false, true },
//			{ false, false, false, false },
//			{ false, false, true, true, true, true, true, true }
//		}
	};
}
