package filemanager; // переведен

import com.one.AbstractFont;
import com.one.ExtGraphics;
import com.one.PaintableObject;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.Sprite;
import java.util.*;
import com.vmx.*;

class waitTimerTask extends TimerTask
{
	cvsWait parent;
	
	public waitTimerTask(cvsWait p)
	{
		parent = p;
	}
	
	public void run()
	{
		parent.repaint();
		//parent.serviceRepaints();
	}
};

/** Пишем "Пожалуйста, ждите..." и читаем список файлов для FileSelect */
public class cvsWait extends gkcCanvas implements Runnable
{
	private Object parent;
	private Thread t;
	private Timer timer;
	private waitTimerTask timerTask;
	private int counter = 0;
	private String selectAfter;
	private int w, h, x, y;
	private AbstractFont f;
	private int fh;
	private String[] msg;
	private int i, msgx, msgy;
	private int runpanel;
	
	/**
	 * Пустой конструктор
	 */
	public cvsWait()
	{
		setFullScreenMode(true);
		
		w = getWidth() * 9 / 10;
		h = w * 7 / 10;

		x = (getWidth() - w) / 2;
		y = (getHeight() - h) / 2;
		
		f = AbstractFont.getFont(0, 1, 0);
		fh = f.getHeight();
		
		msg = f.splitString(Locale.getString(this, Locale.WAIT_PLEASE), w - 47);
		
		msgx = x + images.waitAnimWidth + 10; // 5 слева + значок + 5 справа от значка
		msgy = y + (h - fh * msg.length) / 2;
	}
	
	public static void start(Object parent)
	{
		start(parent, main.manager.currentPanel());
	}
	
	public static void start(Object parent, String selectAfter)
	{
		start(parent, main.manager.currentPanel(), selectAfter);
	}
	
	/**
     * start для случая, когда после загрузки списка
     * файлов надо выбрать первый файл
	 */
	public static void start(Object parent, int panel)
	{
		main.wait.parent = parent;
		main.wait.runpanel = panel;
		main.wait.selectAfter = null;
		main.wait.init();
	}
	
	/**
     * start для случая, когда после загрузки списка
     * указывается то, какой файл надо выбрать
	 */
	public static void start(Object parent, int panel, String selectAfter)
	{
		main.wait.parent = parent;
		main.wait.runpanel = panel;
		main.wait.selectAfter = selectAfter;
		main.wait.init();
	}
	
	/** Общая часть конструктора */
	public void init()
	{
		if(t != null && t.isAlive())
		{
			t.interrupt();
			t = null;
		}
		
		if(timer != null)
		{
			timer.cancel();
			timer = null;
		}
		
		timerTask = new waitTimerTask(this);
		timer = new Timer();
		timer.schedule(timerTask, 0, 100);
		
		t = new Thread(this, "Wait/Listing");
		t.start();
	}
	
	/** Функция потока */
	public void run()
	{
		//String err = null;
		Exception e = null;
		//boolean erred = false;
		
		try
		{
			if(!options.noEffects)
			{
				main.manager.setCurrent(main.wait, runpanel);
			}
			
			main.FileSelect.list(selectAfter);
			timer.cancel();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();

			//ErrScreen.showErrMsg(ex);
			//err = ex.getMessage();
			//erred = true;
			e = ex;
			timer.cancel();
			timer = null;
		}
		finally
		{
			if(e != null)
			{
				//Alert al = new Alert("Error", err, images.error, AlertType.ERROR);
				//al.setTimeout(3000);
				main.currentPath = main.FileSelect.prevpath;
				main.manager.setCurrent(main.FileSelect, runpanel);
				//ErrScreen.showErrMsg(37, e);
			}
			else if(!options.noEffects || main.dsp.getCurrent() != main.FileSelect)
			{
				main.manager.setCurrent(main.FileSelect, runpanel);
			}
		}
	}
	
	/** Функция отрисовки */
	public void paint(ExtGraphics g)
	{
		if(parent != null && parent instanceof PaintableObject)
		{
			((PaintableObject)parent).paint(g);
		}
		else
		{
			g.setColor(ColorScheme.colors[ColorScheme.back1]);
			g.fillRect(0, 0, getWidth(), getHeight());
		}
		
		g.setColor(ColorScheme.colors[ColorScheme.back1]);
		g.fillRoundRect(x, y, w, h, fh, fh);
		
		g.setColor(ColorScheme.colors[ColorScheme.dkborder]);
		g.drawRoundRect(x, y, w, h, fh, fh);
		
		if(images.waitAnim != null)
		{
			g.drawRegion(images.waitAnim, images.waitAnimWidth * counter, 0, images.waitAnimWidth, images.waitAnimHeight, Sprite.TRANS_NONE, x + 5, y + h / 2, 6);
			counter = (counter + 1) % images.waitAnimFrames;
		}
		
		g.setFont(f);
		g.setColor(ColorScheme.colors[ColorScheme.fore]);
//		gWait.translate(this.getWidth() / 2 - 25, this.getHeight() / 2 - 14);
//		gWait.drawString(Locale.getString(this, Locale.WAIT_PLEASE), 0, 0, 20);
		
		for(i = 0; i < msg.length; i++)
		{
			g.drawString(msg[i], msgx, msgy + i * fh, Graphics.LEFT | Graphics.TOP);
		} 
	}
}
