package filemanager;

//import javax.bluetooth.LocalDevice;
import com.vmx.Locale;
import javax.microedition.lcdui.*;

public class diskInfo extends Form implements CommandListener
{
	private Object parent;

	/** Показ информации о диске */
	public diskInfo(Object parent)
	{
		super("");
		setTitle(Locale.getString(this, Locale.DISK_INFO));

		this.parent = parent;
		
		String disk;
		String s;

		if(main.currentPath.length() > 0)
		{
			disk = main.currentPath;
		}
		else
		{
			disk = main.currentFile;
		}

		int index = disk.indexOf('/');

		if(index > 0)
		{
			disk = disk.substring(0, index);
		}

		//StringItem si = new StringItem("", Locale.getString(this, Locale.DISK) + " " + disk + "\n");
		append(new TextField(Locale.getString(this, Locale.DISK), disk, disk.length(), TextField.ANY));

		long size = filesystem.getDiskSpaceTotal(disk + "/");

		if(size >= 0)
		{
			//si = new StringItem(Locale.getString(this, Locale.DISK_TOTAL_SIZE), filesystem.getSizeString(size));

			s = filesystem.getSizeString(size, true);
			append(new TextField(Locale.getString(this, Locale.DISK_TOTAL_SIZE), s, s.length(), TextField.ANY));
		}

		size = filesystem.getDiskSpaceAvailable(disk + "/");

		if(size >= 0)
		{
			s = filesystem.getSizeString(size, true);
			append(new TextField(Locale.getString(this, Locale.DISK_AVAILABLE), s, s.length(), TextField.ANY));
		}

		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.BACK, 1));
		setCommandListener(this);
	}

	/** Обработчик команд от формы свойств */
	public void commandAction(Command c, Displayable d)
	{
		main.dsp.setCurrent(parent);
	}
}
