package filemanager;

import com.one.AbstractFont;
import com.vmx.Locale;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Form;

/**
 * Форма выбора шрифта
 */
public class frmFont extends Form
{
	protected ChoiceGroup cgSize, cgFace, cgStyle;

	public frmFont(String title)
	{
		super(title);

		cgSize = new ChoiceGroup(Locale.getString(this, Locale.SIZE), ChoiceGroup.EXCLUSIVE);

		cgSize.append(Locale.getString(this, Locale.SIZE_SMALL), null);
		cgSize.append(Locale.getString(this, Locale.SIZE_MEDIUM), null);
		cgSize.append(Locale.getString(this, Locale.SIZE_LARGE), null);

		cgFace = new ChoiceGroup(Locale.getString(this, Locale.FONT_FACE), ChoiceGroup.EXCLUSIVE);

		cgFace.append(Locale.getString(this, Locale.FONT_MONOSPACE), null);
		cgFace.append(Locale.getString(this, Locale.FONT_PROPORTIONAL), null);
		cgFace.append(Locale.getString(this, Locale.FONT_SYSTEM), null);

		cgStyle = new ChoiceGroup(Locale.getString(this, Locale.FONT_STYLE), ChoiceGroup.MULTIPLE);

		cgStyle.append(Locale.getString(this, Locale.FONT_BOLD), null);
		cgStyle.append(Locale.getString(this, Locale.FONT_ITALIC), null);
		cgStyle.append(Locale.getString(this, Locale.FONT_UNDERLINED), null);

		append(cgSize);
		append(cgFace);
		append(cgStyle);
	}

	public void setSize(int size)
	{
		switch(size)
		{
			case AbstractFont.SIZE_SMALL:
				cgSize.setSelectedIndex(0, true);
				break;

			case AbstractFont.SIZE_MEDIUM:
				cgSize.setSelectedIndex(1, true);
				break;

			case AbstractFont.SIZE_LARGE:
				cgSize.setSelectedIndex(2, true);
				break;
		}
	}

	public void setFace(int face)
	{
		switch(face)
		{
			case AbstractFont.FACE_MONOSPACE:
				cgFace.setSelectedIndex(0, true);
				break;

			case AbstractFont.FACE_PROPORTIONAL:
				cgFace.setSelectedIndex(1, true);
				break;

			case AbstractFont.FACE_SYSTEM:
				cgFace.setSelectedIndex(2, true);
				break;
		}
	}

	public void setStyle(int style)
	{
		cgStyle.setSelectedIndex(0, (style & AbstractFont.STYLE_BOLD) != 0);
		cgStyle.setSelectedIndex(1, (style & AbstractFont.STYLE_ITALIC) != 0);
		cgStyle.setSelectedIndex(2, (style & AbstractFont.STYLE_UNDERLINED) != 0);
	}

	public int getSize()
	{
		switch(cgSize.getSelectedIndex())
		{
			case 0:
				return AbstractFont.SIZE_SMALL;

			case 1:
				return AbstractFont.SIZE_MEDIUM;

			case 2:
				return AbstractFont.SIZE_LARGE;
		}

		return 0;
	}

	public int getFace()
	{
		switch(cgFace.getSelectedIndex())
		{
			case 0:
				return AbstractFont.FACE_MONOSPACE;

			case 1:
				return AbstractFont.FACE_PROPORTIONAL;

			case 2:
				return AbstractFont.FACE_SYSTEM;
		}

		return 0;
	}

	public int getStyle()
	{
		int style = 0;

		if(cgStyle.isSelected(0))
		{
			style |= AbstractFont.STYLE_BOLD;
		}

		if(cgStyle.isSelected(1))
		{
			style |= AbstractFont.STYLE_ITALIC;
		}

		if(cgStyle.isSelected(2))
		{
			style |= AbstractFont.STYLE_UNDERLINED;
		}

		return style;
	}

	public void setFontIndex(int index)
	{
		setFace(AbstractFont.getFontFace(index));
		setStyle(AbstractFont.getFontStyle(index));
		setSize(AbstractFont.getFontSize(index));
	}

	public int getFontIndex()
	{
		return AbstractFont.getFontIndex(getFace(), getStyle(), getSize());
	}

	public void setFont(AbstractFont font)
	{
		setFace(font.getFace());
		setStyle(font.getStyle());
		setSize(font.getSize());
	}

	public AbstractFont getFont()
	{
		return AbstractFont.getFont(getFace(), getStyle(), getSize());
	}

	public String toString()
	{
		StringBuffer res = new StringBuffer();

		res.append(cgSize.getString(cgSize.getSelectedIndex()));

		res.append(' ');
		res.append(cgFace.getString(cgFace.getSelectedIndex()));

		if(cgStyle.isSelected(0))
		{
			res.append(' ');
			res.append(cgStyle.getString(0));
		}

		if(cgStyle.isSelected(1))
		{
			res.append(' ');
			res.append(cgStyle.getString(1));
		}

		if(cgStyle.isSelected(2))
		{
			res.append(' ');
			res.append(cgStyle.getString(2));
		}

		return res.toString();
	}
}