package filemanager;

import com.vmx.keyConfig;
import com.vmx.Locale;
import javax.microedition.lcdui.*;
import com.vmx.gkcCanvas;

public class frmInitialSetup extends Form implements CommandListener
{
	protected ChoiceGroup cgKeyMap,
	                      cgLang;
	
	public frmInitialSetup()
	{
		super("");
		setTitle(Locale.getString(this, Locale.INITIAL_SETUP));
		
		cgKeyMap = new ChoiceGroup(Locale.getString(this, Locale.PREF_KEYMAP), ChoiceGroup.EXCLUSIVE);
		
		for(int i = 0; i < gkcCanvas.platforms.length; i++)
		{
			cgKeyMap.append(gkcCanvas.platforms[i], null);
			cgKeyMap.setSelectedIndex(i, i == options.keyMap);
		}
		
		cgLang = new ChoiceGroup(Locale.getString(this, Locale.PREF_LANG), ChoiceGroup.EXCLUSIVE);
		
		for(int i = 0; i < Locale.languages.length; i++)
		{
			cgLang.append(Locale.languages[i], null);
			cgLang.setSelectedIndex(i, options.language.equals(Locale.locales[i]));
		}
		
		append(cgLang);
		append(cgKeyMap);
		
		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		setCommandListener(this);
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(dp == this)
		{
			options.keyMap = (byte)cgKeyMap.getSelectedIndex();
			options.language = Locale.locales[cgLang.getSelectedIndex()];
			options.firstTime = 1;

			gkcCanvas.setKeyMap(options.keyMap, options.screenTransform);
			keyConfig.addDefaultKeys();
			
			GraphicAlert alert = new GraphicAlert(Locale.getString(this, Locale.ATTENTION), Locale.getString(this, Locale.NEED_RESTART), images.getAlertIcon(AlertType.CONFIRMATION), null);

			alert.addCommand(new Command(Locale.getString(this, Locale.YES_CMD), Command.OK, 1));
			alert.addCommand(new Command(Locale.getString(this, Locale.NO_CMD), Command.CANCEL, 2));
			alert.setCommandListener(this);

			main.dsp.setCurrent(alert);
		}
		else
		{
			if(c.getCommandType() == Command.OK)
			{
				main.loader.restartApp();
			}
			else
			{
				main.destroyApp();
			}
		}
	}
}
