package filemanager;

import com.one.AbstractFont;
import com.one.ErrScreen;
import com.one.FileSource;
import com.one.ModuleRegistry;
import javax.microedition.lcdui.*;
import com.vmx.*;
import java.util.Enumeration;
import java.util.Vector;

public class frmNewFile extends Form implements CommandListener, ItemStateListener
{
	public static Image ICON_DTE;
	public static Image ICON_HEX;
	public static Image ICON_ASC;

	private Object parent;

	private Vector filesources;
	private String filext;

	private TextField tfFileName;
	private ChoiceGroup cgFileType;

	private List lstNameFormat;

	public frmNewFile(Object parent, int type)
	{
		super("");
		setTitle(Locale.getString(this, Locale.CREATE_NEW_FILE));
		
		this.parent = parent;

		Enumeration fse = (type == FileSource.TYPE_CONTAINER ? ModuleRegistry.listContainerSources() : ModuleRegistry.listFileSources());
		String filesource;

		cgFileType = new ChoiceGroup(Locale.getString(this, Locale.FILE_TYPE), Choice.EXCLUSIVE);
		filesources = new Vector();
		int index = 0;

		while(fse.hasMoreElements())
		{
			filesource = (String)fse.nextElement();

			cgFileType.append(ModuleRegistry.getModuleName(filesource), ModuleRegistry.getIcon(filesource));
			filesources.addElement(filesource);
		}

		if(filesources.isEmpty())
		{
			addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.BACK, 2));
			setCommandListener(this);
		}
		else
		{
			cgFileType.setSelectedIndex(index, true);

			filext = AuxClass.formatFileExtension(ModuleRegistry.getExtension((String)filesources.elementAt(index)));
			tfFileName = new TemplateTextField(Locale.getString(this, Locale.NAME), "", 256, TextField.ANY);

			append(tfFileName);
			append(cgFileType);

			addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
			addCommand(new Command(Locale.getString(this, Locale.NAME_FORMAT_CMD), Command.ITEM, 2));
			addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.BACK, 3));
			setCommandListener(this);
			setItemStateListener(this);

			lstNameFormat = new List(Locale.getString(this, Locale.NAME_FORMAT_CMD), Choice.IMPLICIT);

			if(ICON_DTE == null)
			{
				AbstractFont font = AbstractFont.getFont(AbstractFont.FACE_SYSTEM, AbstractFont.STYLE_PLAIN, AbstractFont.SIZE_SMALL);
				int color = images.cPlayFore2; // (images.cPlayFore2 & 0xFFFFFF) | 0x80000000;

				ICON_DTE = images.getIcon(images.iFile, "D", font, color);
				ICON_HEX = images.getIcon(images.iFile, "H", font, color);
				ICON_ASC = images.getIcon(images.iFile, "A", font, color);
			}

			lstNameFormat.append(AuxClass.timeToFileName(-1), ICON_DTE);
			lstNameFormat.append(Long.toString(System.currentTimeMillis(), 16).toUpperCase(), ICON_HEX);
			lstNameFormat.append(Long.toString(System.currentTimeMillis(), Character.MAX_RADIX).toUpperCase(), ICON_ASC);

			String s = main.currentFile.endsWith("/") ? main.currentFile.substring(0, main.currentFile.length() - 1) : main.currentFile;
			Image icon = ModuleRegistry.getIcon(AuxClass.getFileExtension(s));
			lstNameFormat.append(s, icon != null ? icon : images.getIcon(images.iFile));

			s = main.currentPath.substring(0, main.currentPath.length() - 1);
			s = s.substring(s.lastIndexOf('/') + 1);
			lstNameFormat.append(s.endsWith(":") ? s.substring(0, s.length() - 1) : s, images.getIcon(images.iFolder));

			if(options.nfNameFormat >= 0 && options.nfNameFormat < lstNameFormat.size())
			{
				lstNameFormat.setSelectedIndex(options.nfNameFormat, true);
			}

			lstNameFormat.addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 2));
			lstNameFormat.setCommandListener(this);

			commandAction(List.SELECT_COMMAND, lstNameFormat);
		}
	}

	public void commandAction(Command command, Displayable displayable)
	{
		if(displayable == this)
		{
			if(command.getCommandType() == Command.OK)
			{
				String filename = main.currentPath + tfFileName.getString();

				if(filesystem.isFileExist(filename)) // уже существует
				{
					main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.NAME_EXIST_SELECT_ANOTHER), AlertType.WARNING, 3000, this);
				}
				else
				{
					try
					{
						((FileSource)ModuleRegistry.getModuleInstance((String)filesources.elementAt(cgFileType.getSelectedIndex()))).createFile(filename);
					}
					catch(Exception e)
					{
						ErrScreen.showErrMsg(128, e);
					}
				}
			}
			else if(command.getCommandType() == Command.ITEM)
			{
				main.dsp.setCurrent(lstNameFormat);
			}
			else
			{
				main.dsp.setCurrent(parent);
			}
		}
		else if(displayable == lstNameFormat)
		{
			if(command == List.SELECT_COMMAND)
			{
				options.nfNameFormat = lstNameFormat.getSelectedIndex();
				tfFileName.setString(lstNameFormat.getString(options.nfNameFormat) + filext);
			}

			main.dsp.setCurrent(this);
		}
	}
	
	public void itemStateChanged(Item item)
	{
		if(item == cgFileType)
		{
			String newext = AuxClass.formatFileExtension(ModuleRegistry.getExtension((String)filesources.elementAt(cgFileType.getSelectedIndex())));

			String filename = tfFileName.getString();
			int index = filename.lastIndexOf('.');
			
			if(index >= 0)
			{
				String ext = filename.substring(index);

				if(ext.equalsIgnoreCase(filext))
				{
					filename = filename.substring(0, index) + newext;
				}
				else if(!ext.equalsIgnoreCase(newext))
				{
					filename += newext;
				}
			}
			else
			{
				filename += newext;
			}

			tfFileName.setString(filename);
			filext = newext;
		}
	}
}
