package filemanager; // переведен

import com.vmx.Locale;
import com.one.TextProcessor;
import com.vmx.AuxClass;
import javax.microedition.lcdui.*;

public class frmNewFolder extends Form implements CommandListener
{
	private Object parent;
	private TextField tf;

	public frmNewFolder(Object parent)
	{
		super("");
		setTitle(Locale.getString(this, Locale.CREATE_NEW_FOLDER));

		this.parent = parent;

		tf = new TemplateTextField(Locale.getString(this, Locale.NAME), AuxClass.timeToFileName(-1), 256, TextField.ANY);

		append(tf);

		addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.BACK, 1));
		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		setCommandListener(this);
	}

	public void commandAction(Command command, Displayable displayable)
	{
		if(command.getCommandType() == Command.OK)
		{
			String s = tf.getString();

			if(s.length() == 0)
			{
				return;
			}

			if(!AuxClass.checkFileName(s))
			{
				main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.RESTRICTED_FILE_NAME, TextProcessor.interlaceString(AuxClass.RESTRICTED_CHARS, " ")), AlertType.WARNING, 3000, this);
				return;
			}

			s = main.currentPath + s + "/";

			if(filesystem.isFileExist(s))
			{
				main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.NAME_EXIST_SELECT_ANOTHER), AlertType.WARNING, 3000, this);
				return;
			}

			if(!filesystem.makeNewDir(s))
			{
				main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.NOT_CREATE_NEW_FOLDER), AlertType.ERROR, 3000, parent);
				return;
			}

			cvsWait.start(main.FileSelect, tf.getString() + "/");
		}
		else
		{
			main.dsp.setCurrent(parent);
		}
	}
}
