package filemanager; // переведен

import com.classpath.hash.HashUtil;
import com.classpath.hash.MessageDigest;
import com.classpath.hash.Sha160;
import com.one.AbstractFont;
import com.one.ArchiveContainer;
import com.one.ErrScreen;
import com.one.GraphicFont;
import com.one.ModuleRegistry;
import com.one.OptionStorage;
import com.one.Renderer;
import com.one.file.Connector;
import com.vmx.AuxClass;
import com.vmx.Locale;
import com.vmx.StringEncoder;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;

public class frmOptions extends Form implements CommandListener, ItemCommandListener, ItemStateListener
{				
	protected ChoiceGroup cgLang,
	                      cgVisual,
	                      cgBrowse,
	                      cgListSortBy,
	                      cgSortOptions,
	                      cgColorScheme,
	                      cgArcEnc,
				          cgLightControl,
				          //cgOptions_screenTransform,
						  cgFullFileNames,
						  cgLargeFont;
	
	protected TextField tfKeyVibraDuration,
			            tfMMDelay,
			            tfMMThreshold,
			            tfLongScrollSpeed,
						tfTempFileDir,
						tfNewFileNameFormat,
						tfErrorLogFile;
				
	protected Object parent;
	protected boolean restart_flag = false;

	protected Vector modules;
	protected List modlist;
	protected List typelist;

	protected frmFont fontForm;
	protected Form frmFontSetup;
	protected StringItem siSelectedFont;
	protected StringItem siInstalledFont;
	protected TextField tfFontPath;

	protected Form passForm;
	protected StringItem siLaunchPassword;
	protected StringItem siOptionsPassword;

	protected MessageDigest md;
	protected TextBox tbPassword;
	protected int passwordFor;

	protected Command cmdOK;
	protected Command cmdModules;
	protected Command cmdFonts;
	protected Command cmdPasswords;
	protected Command cmdMIME;
	protected Command cmdCHAPI;
	protected Command cmdBack;
	protected Command cmdSelectAll;
	protected Command cmdDeselectAll;

	public frmOptions(Object parent)
	{
		super("");
		setTitle(Locale.getString(this, Locale.PREFERENCES_CMD));
		
		this.parent = parent;
		
		// *** Визуальные эффекты ***
		cgVisual = new ChoiceGroup(Locale.getString(this, Locale.PREF_VISUAL), Choice.MULTIPLE);
		
		// Не показывать "Пожалуйста, подождите" (cvsWait)
		cgVisual.append(Locale.getString(this, Locale.PREF_NO_EFFECTS), null);
		cgVisual.setSelectedIndex(0, options.noEffects);
		
		// Показывать сообщения об ошибках
		cgVisual.append(Locale.getString(this, Locale.PREF_SHOW_ERRORS), null);
		cgVisual.setSelectedIndex(1, options.showErrors);
		
		// Показывать номера в меню
		cgVisual.append(Locale.getString(this, Locale.PREF_SHOW_MENU_NUM), null);
		cgVisual.setSelectedIndex(2, options.showMenuNum);
		
		// Курсор в виде рамки
		cgVisual.append(Locale.getString(this, Locale.PREF_FRAME_CURSOR), null);
		cgVisual.setSelectedIndex(3, options.frameCursor);
		
		// Проигрывать сигналы в сообщениях
		cgVisual.append(Locale.getString(this, Locale.PREF_PLAY_ALERT_SOUNDS), null);
		cgVisual.setSelectedIndex(4, options.playAlertSounds);
		
		// Расширенное меню
		cgVisual.append(Locale.getString(this, Locale.PREF_USE_FULL_MENU), null);
		cgVisual.setSelectedIndex(5, options.useFullMenu);
		
		// Часы внизу экрана
		cgVisual.append(Locale.getString(this, Locale.PREF_ALTER_CLOCK_POS), null);
		cgVisual.setSelectedIndex(6, options.alterClockPos);
		
		// Поменять софт-клавиши
		cgVisual.append(Locale.getString(this, Locale.PREF_SWAP_SOFT_KEYS), null);
		cgVisual.setSelectedIndex(7, options.swapSoftKeys);
		
		// Переводить курсор при выделении
		cgVisual.append(Locale.getString(this, Locale.PREF_MARK_MOVE_NEXT), null);
		cgVisual.setSelectedIndex(8, options.markMoveNext);

		// Улучшенные градиенты
		cgVisual.append(Locale.getString(this, Locale.PREF_DITHER_GRADIENTS), null);
		cgVisual.setSelectedIndex(9, options.ditherGradients);

//		// Прозрачные градиенты
//		cgVisual.append(Locale.getString(this, Locale.PREF_ALPHA_GRADIENTS), null);
//		cgVisual.setSelectedIndex(10, options.alphaGradients);

		// "Выход" в списке дисков
		cgVisual.append(Locale.getString(this, Locale.PREF_EXIT_FROM_DRIVE_LIST), null);
		cgVisual.setSelectedIndex(10, options.exitFromDriveList);

		// Шаблоны для полей ввода
		cgVisual.append(Locale.getString(this, Locale.PREF_USE_TEMPLATES), null);
		cgVisual.setSelectedIndex(11, TemplateTextField.useTemplates);

		// *** Полные имена файлов ***
		cgFullFileNames = new ChoiceGroup(Locale.getString(this, Locale.PREF_FULL_FILE_NAMES), Choice.MULTIPLE);

		cgFullFileNames.append(Locale.getString(this, Locale.IN_BUFFER), null);
		cgFullFileNames.setSelectedIndex(0, options.fullNamesInBuf);

		cgFullFileNames.append(Locale.getString(this, Locale.IN_FAVOURITES), null);
		cgFullFileNames.setSelectedIndex(1, options.fullNamesInFav);

		// *** Крупный шрифт ***
		cgLargeFont = new ChoiceGroup(Locale.getString(this, Locale.PREF_LARGE_FONT), Choice.MULTIPLE);

		cgLargeFont.append(Locale.getString(this, Locale.IN_FILE_LIST), null);
		cgLargeFont.setSelectedIndex(0, options.largeFontInList);

		cgLargeFont.append(Locale.getString(this, Locale.IN_MENU), null);
		cgLargeFont.setSelectedIndex(1, options.largeFontInMenu);

		// *** Поворот экрана ***
//		cgOptions_screenTransform = new ChoiceGroup(Locale.getString(this, Locale.PREF_SCREEN_TRANSFORM), Choice.EXCLUSIVE);
//
//		cgOptions_screenTransform.append(Locale.getString(this, Locale.ROTATE_BY, "0"), null);
//		cgOptions_screenTransform.append(Locale.getString(this, Locale.ROTATE_BY, "90"), null);
//		cgOptions_screenTransform.append(Locale.getString(this, Locale.ROTATE_BY, "180"), null);
//		cgOptions_screenTransform.append(Locale.getString(this, Locale.ROTATE_BY, "270"), null);
//
//		switch(options.screenTransform)
//		{
//			case Sprite.TRANS_ROT90:
//				cgOptions_screenTransform.setSelectedIndex(1, true);
//				break;
//
//			case Sprite.TRANS_ROT180:
//				cgOptions_screenTransform.setSelectedIndex(2, true);
//				break;
//
//			case Sprite.TRANS_ROT270:
//				cgOptions_screenTransform.setSelectedIndex(3, true);
//				break;
//
//			default:
//				cgOptions_screenTransform.setSelectedIndex(0, true);
//				break;
//		}

		// *** Постоянная подсветка ***
		cgLightControl = new ChoiceGroup(Locale.getString(this, Locale.PREF_LIGHT_CONTROL_MODE), Choice.EXCLUSIVE);

		cgLightControl.append(Locale.getString(this, Locale.DISABLED), null);
		cgLightControl.append(Locale.getString(this, Locale.ENABLED), null);
		cgLightControl.append(Locale.getString(this, Locale.AUTOMATIC), null);

		cgLightControl.setSelectedIndex(options.lightControlMode, true);
		
		// *** Параметры просмотра и выполнения ***
		cgBrowse = new ChoiceGroup(Locale.getString(this, Locale.PREF_BROWSE), Choice.MULTIPLE);
		
		// Показывать скрытые файлы и папки
		cgBrowse.append(Locale.getString(this, Locale.PREF_SHOW_HIDDEN_FILES), null);
		cgBrowse.setSelectedIndex(0, options.showHidden);
		
		// Проверять аттрибуты файлов
		cgBrowse.append(Locale.getString(this, Locale.PREF_CHECK_FILE_ATTRIB), null);
		cgBrowse.setSelectedIndex(1, options.checkFileAttrib);
		
		// Точная проверка директорий (через FileConnection)
		cgBrowse.append(Locale.getString(this, Locale.PREF_ACCURATE_DIR_CHECK), null);
		cgBrowse.setSelectedIndex(2, options.accurateDirCheck);
		
		// Открывать неподдерживаемые как текст
		cgBrowse.append(Locale.getString(this, Locale.PREF_OPEN_NOT_SUPP), null);
		cgBrowse.setSelectedIndex(3, options.openNotSupported);
		
		// Сохранять открытые пути
		cgBrowse.append(Locale.getString(this, Locale.PREF_REMEMBER_PATH), null);
		cgBrowse.setSelectedIndex(4, options.rememberPath);

		// Загружать "комплементарные кодовые таблицы" %
		cgBrowse.append(Locale.getString(this, Locale.PREF_CACHE_CODE_PAGES), null);
		cgBrowse.setSelectedIndex(5, options.cacheCodePages);

		// Разрешить дуплексный доступ к файлам
		cgBrowse.append(Locale.getString(this, Locale.PREF_DUPLEX_FILE_ACCESS), null);
		cgBrowse.setSelectedIndex(6, AuxClass.duplexFileAccess);

		// Выгружать модули при закрытии
		cgBrowse.append(Locale.getString(this, Locale.PREF_UNLOAD_MODULES), null);
		cgBrowse.setSelectedIndex(7, options.unloadModules);

		// Распаковывать файлы в ОЗУ
		cgBrowse.append(Locale.getString(this, Locale.PREF_VIRTUALIZE_TO_RAM), null);
		cgBrowse.setSelectedIndex(8, ArchiveContainer.virtualizeToRAM);
		
		// *** Настройка сортировки ***
		cgListSortBy = new ChoiceGroup(Locale.getString(this, Locale.PREF_SORT_FILE_LIST), Choice.EXCLUSIVE);
		
		cgListSortBy.append(Locale.getString(this, Locale.SORT_NONE), null);
		cgListSortBy.append(Locale.getString(this, Locale.SORT_BY_NAME), null);
		cgListSortBy.append(Locale.getString(this, Locale.SORT_BY_TYPE), null);
		cgListSortBy.append(Locale.getString(this, Locale.SORT_BY_DATE), null);
		cgListSortBy.append(Locale.getString(this, Locale.SORT_BY_SIZE), null);
		
		cgListSortBy.setSelectedIndex(options.listSortBy, true);
		
		// *** Опции сортировки ***
		cgSortOptions = new ChoiceGroup(Locale.getString(this, Locale.PREF_SORT_OPTIONS), Choice.MULTIPLE);
		
		// В обратном порядке
		cgSortOptions.append(Locale.getString(this, Locale.SORT_REVERSE_ORDER), null);
		cgSortOptions.setSelectedIndex(0, options.listSortReverseOrder);
		
		// Не учитывать регистр
		cgSortOptions.append(Locale.getString(this, Locale.IGNORE_CASE), null);
		cgSortOptions.setSelectedIndex(1, options.listSortIgnoreCase);

		// *** Скорость прокрутки длинных имен
		tfLongScrollSpeed = new TextField(Locale.getString(this, Locale.PREF_LONG_SCROLL_SPEED), Float.toString(options.longScrollSpeed), 20, TextField.DECIMAL);

		// *** Вибрация при нажатии клавиш ***
		tfKeyVibraDuration = new TextField(Locale.getString(this, Locale.PREF_KEY_VIBRA_DURATION), Integer.toString(options.keyVibraDuration), 3, TextField.NUMERIC);

		// *** Настройки монитора памяти ***

		// Шаг монитора памяти
		tfMMDelay = new TextField(Locale.getString(this, Locale.PREF_MM_DELAY), Integer.toString(options.mmDelay), 4, TextField.NUMERIC);

		// Порог сборщика мусора
		tfMMThreshold = new TextField(Locale.getString(this, Locale.PREF_MM_THRESHOLD), Integer.toString(options.mmThreshold), 3, TextField.NUMERIC);

		// *** Папка временных для файлов ***
		tfTempFileDir = new TemplateTextField(Locale.getString(this, Locale.PREF_TEMP_FILE_DIR), Connector.getTempFileDir(), 256, TextField.ANY);

		// *** Файл журнала ошибок ***
		tfErrorLogFile = new TemplateTextField(Locale.getString(this, Locale.PREF_ERROR_LOG_FILE), ErrScreen.getLogFileName(), 256, TextField.ANY);

		// *** Формат имен новых файлов ***
		tfNewFileNameFormat = new TemplateTextField(Locale.getString(this, Locale.PREF_NEW_FILE_NAME_FORMAT), AuxClass.timeToFileNameFormat, 256, TextField.ANY);
		
		// *** Цветовые схемы ***
		cgColorScheme = new ChoiceGroup(Locale.getString(this, Locale.COLOR_SCHEME), Choice.EXCLUSIVE);
		
		for(int i = 0; i < ColorScheme.schemes.length; i++)
		{
			cgColorScheme.append(ColorScheme.schemes[i], null);
		}
		
		cgColorScheme.append(Locale.getString(this, Locale.PREF_CUSTOM_COLOR_SCHEME), null);

		if(options.colorScheme == ColorScheme.SCHEME_CUSTOM)
		{
			cgColorScheme.setSelectedIndex(cgColorScheme.size() - 1, true);
		}
		else
		{
			cgColorScheme.setSelectedIndex(options.colorScheme, true);
		}
		
		// *** Список языков ***
		cgLang = new ChoiceGroup(Locale.getString(this, Locale.PREF_LANG), Choice.EXCLUSIVE);
		
		for(int i = 0; i < Locale.languages.length; i++)
		{
			cgLang.append(Locale.languages[i], null);
			cgLang.setSelectedIndex(i, options.language.equals(Locale.locales[i]));
		}
		
		// *** Кодировка архивов ***
		cgArcEnc = new ChoiceGroup(Locale.getString(this, Locale.PREF_ARCHIVE_ENCODING), Choice.EXCLUSIVE);
		
		cgArcEnc.append(StringEncoder.ENC_NAME_UTF8, null);
		
		for(int i = 0; i < StringEncoder.encnames.length; i++)
		{
			cgArcEnc.append(StringEncoder.encnames[i], null);
		}
		
		if(options.arcEnc == StringEncoder.ENC_UTF8)
		{
			cgArcEnc.setSelectedIndex(0, true);
		}
		else
		{
			cgArcEnc.setSelectedIndex(options.arcEnc + 1, true);
		}

		append(cgLang);
		append(cgBrowse);
		append(cgListSortBy);
		append(cgSortOptions);
		append(cgVisual);
		append(cgFullFileNames);
		append(cgLargeFont);
		append(cgLightControl);
		append(cgColorScheme);
		//append(cgOptions_screenTransform);
		append(tfLongScrollSpeed);
		append(tfKeyVibraDuration);
		append(cgArcEnc);
		append(tfNewFileNameFormat);
		append(tfTempFileDir);
		append(tfErrorLogFile);
		append(tfMMDelay);
		append(tfMMThreshold);
		
		addCommand(cmdOK = new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		addCommand(cmdModules = new Command(Locale.getString(this, Locale.MODULES_CMD), Command.OK, 2));
		addCommand(cmdFonts = new Command(Locale.getString(this, Locale.FONTS_CMD), Command.OK, 3));
		addCommand(cmdPasswords = new Command(Locale.getString(this, Locale.PASSWORDS_CMD), Command.OK, 4));
		addCommand(cmdMIME = new Command(Locale.getString(this, Locale.MIME_TYPES_CMD), Command.OK, 5));

//		if(AuxClass.classExists("javax.microedition.content.Registry"))
//		{
//			addCommand(cmdCHAPI = new Command(Locale.getString(this, Locale.CHAPI_CMD), Command.OK, 6));
//		}

		addCommand(cmdBack = new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 7));
		
		setCommandListener(this);
		setItemStateListener(this);
	}

	protected void createModuleList()
	{
		if(modlist != null)
		{
			return;
		}

		modules = new Vector();
		modlist = new List(Locale.getString(this, Locale.MODULES_CMD), Choice.IMPLICIT);

		Enumeration e = ModuleRegistry.listOptionStores();
		String s;

		while(e.hasMoreElements())
		{
			s = (String)e.nextElement();

			modules.addElement(s);
			modlist.append(ModuleRegistry.getModuleName(s), null);
		}

		modlist.addCommand(cmdBack);
		modlist.setCommandListener(this);
	}

//	protected void createTypeList()
//	{
//		if(typelist != null)
//		{
//			return;
//		}
//
//		typelist = new List(Locale.getString(this, Locale.CHAPI_CMD), Choice.MULTIPLE);
//
//		Enumeration extensions = FileSystemObject.sortFileList(ModuleRegistry.listExtensions());
//		String ext;
//
//		Hashtable indices = new Hashtable();
//		int index = 0;
//
//		while(extensions.hasMoreElements())
//		{
//			ext = (String)extensions.nextElement();
//			typelist.append(ext, ModuleRegistry.getIcon(ext));
//
//			indices.put(ext, new Integer(index++));
//		}
//
//		try
//		{
//			String[] suffixes = Registry.getRegistry(UniFM.class.getName()).getSuffixes();
//			Integer integer;
//
//			for(int i = 0; i < suffixes.length; i++)
//			{
//				integer = (Integer)indices.get(suffixes[i].substring(1).toLowerCase());
//
//				if(integer != null)
//				{
//					typelist.setSelectedIndex(integer.intValue(), true);
//				}
//			}
//		}
//		catch(Throwable t)
//		{
//			t.printStackTrace();
//		}
//
//		typelist.addCommand(cmdOK);
//
//		typelist.addCommand(cmdSelectAll = new Command(Locale.getString(this, Locale.MARK_ALL_CMD), Command.OK, 2));
//		typelist.addCommand(cmdDeselectAll = new Command(Locale.getString(this, Locale.DEMARK_ALL_CMD), Command.OK, 3));
//
//		typelist.addCommand(cmdBack);
//
//		typelist.setCommandListener(this);
//	}

	protected void createFontForms()
	{
		if(fontForm != null)
		{
			return;
		}

		fontForm = new frmFont(Locale.getString(this, Locale.FONT_CONFIG));

		fontForm.addCommand(new Command(Locale.getString(this, Locale.SELECT_CMD), Command.OK, 1));
		fontForm.addCommand(cmdBack);
		fontForm.setCommandListener(this);

		frmFontSetup = new Form(Locale.getString(this, Locale.FONT_CONFIG));

		siSelectedFont = new StringItem(Locale.getString(this, Locale.FONT_CMD) + ":\n", null);
		siSelectedFont.setLayout(Item.LAYOUT_NEWLINE_AFTER);

		siInstalledFont = new StringItem(Locale.getString(this, Locale.INSTALLED_FONT) + ":\n", null);
		siInstalledFont.setLayout(Item.LAYOUT_NEWLINE_AFTER);

		tfFontPath = new TextField(Locale.getString(this, Locale.FONT_PATH), "", 256, TextField.ANY);

		frmFontSetup.append(siSelectedFont);
		frmFontSetup.append(siInstalledFont);
		frmFontSetup.append(tfFontPath);

		frmFontSetup.addCommand(cmdOK);
		frmFontSetup.addCommand(cmdBack);
		frmFontSetup.setCommandListener(this);
	}

	protected void createPasswordForm()
	{
		if(passForm != null)
		{
			return;
		}

		passForm = new Form(Locale.getString(this, Locale.PASSWORDS_CMD));

		Command cmdSelect = new Command(Locale.getString(this, Locale.SELECT_CMD), Command.ITEM, 1);

		siLaunchPassword = new StringItem(Locale.getString(this, Locale.PASS_FOR_LAUNCH), null, Item.BUTTON);
		siLaunchPassword.addCommand(cmdSelect);
		siLaunchPassword.setItemCommandListener(this);

		siOptionsPassword = new StringItem(Locale.getString(this, Locale.PASS_FOR_OPTIONS), null, Item.BUTTON);
		siOptionsPassword.addCommand(cmdSelect);
		siOptionsPassword.setItemCommandListener(this);

		updatePasswordLabels();

		passForm.append(siLaunchPassword);
		passForm.append(siOptionsPassword);

		passForm.addCommand(cmdBack);
		passForm.setCommandListener(this);

		tbPassword = new TextBox(Locale.getString(this, Locale.ENTER_PASSWORD), "", 1024, TextField.SENSITIVE);

		tbPassword.addCommand(cmdOK);
		tbPassword.addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.CANCEL, 2));
		tbPassword.setCommandListener(this);

		md = new Sha160();
	}

	protected void updatePasswordLabels()
	{
		//siLaunchPassword.setText(Locale.getString(this, options.launchPasswordHash.equals(options.EMPTY_HASH) ? Locale.NO_CMD : Locale.YES_CMD));
		//siOptionsPassword.setText(Locale.getString(this, options.optionsPasswordHash.equals(options.EMPTY_HASH) ? Locale.NO_CMD : Locale.YES_CMD));
	}
	
	/**
	 * Обработчик команд
	 */
	public void commandAction(Command c, Displayable d)
	{
		if(d == this)
		{
			if(c == cmdOK)
			{
				options.noEffects = cgVisual.isSelected(0);
				options.showErrors = cgVisual.isSelected(1);
				options.showMenuNum = cgVisual.isSelected(2);
				options.frameCursor = cgVisual.isSelected(3);
				options.playAlertSounds = cgVisual.isSelected(4);
				options.useFullMenu = cgVisual.isSelected(5);
				options.alterClockPos = cgVisual.isSelected(6);
				options.swapSoftKeys = cgVisual.isSelected(7);
				options.markMoveNext = cgVisual.isSelected(8);
				options.ditherGradients = cgVisual.isSelected(9);
//				options.alphaGradients = cgVisual.isSelected(10);
				options.exitFromDriveList = cgVisual.isSelected(10);
				TemplateTextField.useTemplates = cgVisual.isSelected(11);

				options.fullNamesInBuf = cgFullFileNames.isSelected(0);
				options.fullNamesInFav = cgFullFileNames.isSelected(1);

				options.largeFontInList = cgLargeFont.isSelected(0);
				options.largeFontInMenu = cgLargeFont.isSelected(1);

				options.lightControlMode = cgLightControl.getSelectedIndex();

				options.keyVibraDuration = Integer.parseInt(tfKeyVibraDuration.getString());
				Renderer.setVibraDuration(options.keyVibraDuration);

				options.longScrollSpeed = Float.parseFloat(tfLongScrollSpeed.getString());

				options.mmDelay = Integer.parseInt(tfMMDelay.getString());
				options.mmThreshold = Integer.parseInt(tfMMThreshold.getString());

				main.monitor.setDelay(options.mmDelay);
				main.monitor.setThreshold(options.mmThreshold);

				AuxClass.timeToFileNameFormat = tfNewFileNameFormat.getString();
				Connector.setTempFileDir(tfTempFileDir.getString());
				ErrScreen.setLogFileName(tfErrorLogFile.getString());

				if(cgArcEnc.getSelectedIndex() == 0)
				{
					options.arcEnc = StringEncoder.ENC_UTF8;
				}
				else
				{
					options.arcEnc = cgArcEnc.getSelectedIndex() - 1;
				}

				StringEncoder.ENC_ARCHIVE = options.arcEnc;

				//images.loadIcons();

	//			if(cgOptions_show3.isSelected(0) != options.showDisk3)
	//			{
	//				options.showDisk3 = cgOptions_show3.isSelected(0);
	//				cvsWait.start();
	//			}

				//options.showDisk3 = cgOptions_show3.isSelected(0);

				options.showHidden = cgBrowse.isSelected(0);
				options.checkFileAttrib = cgBrowse.isSelected(1);
				options.accurateDirCheck = cgBrowse.isSelected(2);
				options.openNotSupported = cgBrowse.isSelected(3);
				options.rememberPath = cgBrowse.isSelected(4);
				options.cacheCodePages = cgBrowse.isSelected(5);
				AuxClass.duplexFileAccess = cgBrowse.isSelected(6);
				options.unloadModules = cgBrowse.isSelected(7);
				ArchiveContainer.virtualizeToRAM = cgBrowse.isSelected(8);

				options.listSortBy = cgListSortBy.getSelectedIndex();

				options.listSortReverseOrder = cgSortOptions.isSelected(0);
				options.listSortIgnoreCase = cgSortOptions.isSelected(1);

				options.colorScheme = cgColorScheme.getSelectedIndex();

				if(options.colorScheme == cgColorScheme.size() - 1)
				{
					options.colorScheme = ColorScheme.SCHEME_CUSTOM;
				}
				else
				{
					try
					{
						if(ColorScheme.loadColorScheme(options.colorScheme))
						{
							main.FileSelect.updateModuleList();
						}

						//main.FileSelect.updateGradients();
					}
					catch(Exception e)
					{
						ErrScreen.showErrMsg(49, e);
					}
				}

				try
				{
					Locale.loadLocale(Locale.locales[cgLang.getSelectedIndex()]);
					options.language = Locale.lang;
				}
				catch(Exception e)
				{
					ErrScreen.showErrMsg(50, e);

					try
					{
						Locale.loadLocale(options.language);
					}
					catch(Exception e1)
					{
						//ErrScreen.showErrMsg("Cannot load even previous \"" + Locale.lang + "\" locale", e);
					}
				}

				main.startLightControl(false);

	//			switch(cgOptions_screenTransform.getSelectedIndex())
	//			{
	//				case 0:
	//					options.screenTransform = Sprite.TRANS_NONE;
	//					break;
	//
	//				case 1:
	//					options.screenTransform = Sprite.TRANS_ROT90;
	//					break;
	//
	//				case 2:
	//					options.screenTransform = Sprite.TRANS_ROT180;
	//					break;
	//
	//				case 3:
	//					options.screenTransform = Sprite.TRANS_ROT270;
	//					break;
	//			}

				options.saveOptions();
			}
			else if(c == cmdModules)
			{
				createModuleList();
				main.dsp.setCurrent(modlist);
				return;
			}
			else if(c == cmdFonts)
			{
				createFontForms();
				main.dsp.setCurrent(fontForm);
				return;
			}
			else if(c == cmdPasswords)
			{
				createPasswordForm();
				main.dsp.setCurrent(passForm);
				return;
			}
			else if(c == cmdMIME)
			{
				MimeType.showTypeList(this);
				return;
			}
//			else if(c == cmdCHAPI)
//			{
//				createTypeList();
//				main.dsp.setCurrent(typelist);
//				return;
//			}

			if(restart_flag)
			{
				GraphicAlert alert = new GraphicAlert(Locale.getString(this, Locale.ATTENTION), Locale.getString(this, Locale.NEED_RESTART), images.getAlertIcon(AlertType.CONFIRMATION), AlertType.CONFIRMATION);

				alert.addCommand(new Command(Locale.getString(this, Locale.YES_CMD), Command.OK, 1));
				alert.addCommand(new Command(Locale.getString(this, Locale.NO_CMD), Command.CANCEL, 2));
				alert.setCommandListener(this);

				main.dsp.setCurrent(alert);
			}
			else if(c == cmdBack)
			{
				main.dsp.setCurrent(parent);
			}
			else
			{
				cvsWait.start(main.FileSelect, main.currentFile);
			}
		}
		else if(d == modlist)
		{
			if(c == List.SELECT_COMMAND)
			{
				((OptionStorage)ModuleRegistry.getModuleInstance((String)modules.elementAt(modlist.getSelectedIndex()))).showEditor(modlist);
			}
			else
			{
				main.dsp.setCurrent(this);
			}
		}
//		else if(d == typelist)
//		{
//			if(c == cmdOK)
//			{
//				String classname = UniFM.class.getName();
//
//				try
//				{
//					Registry registry = Registry.getRegistry(classname);
//					registry.unregister(classname);
//
//					Vector vector = new Vector(typelist.size());
//
//					for(int i = 0; i < typelist.size(); i++)
//					{
//						if(typelist.isSelected(i))
//						{
//							vector.addElement(typelist.getString(i));
//						}
//					}
//
//					if(vector.size() > 0)
//					{
//						String[] suffixes = TextProcessor.vectorToStringArray(vector);
//
//						vector.removeAllElements();
//						String type;
//
//						for(int i = 0; i < vector.size(); i++)
//						{
//							type = MimeType.getType(suffixes[i]);
//
//							if(type != null && !vector.contains(type))
//							{
//								vector.addElement(type);
//							}
//
//							suffixes[i] = "." + suffixes[i];
//						}
//
//						String[] types = TextProcessor.vectorToStringArray(vector);
//
//						String[] actions = new String[]
//						{
//							ContentHandler.ACTION_OPEN
//						};
//
//						String[] actionnames = new String[]
//						{
//							Locale.getString(this, Locale.CHAPI_OPEN_WITH)
//						};
//
//						ActionNameMap[] namemaps = new ActionNameMap[]
//						{
//							new ActionNameMap(actions, actionnames, Locale.lang)
//						};
//
//						registry.register(classname, types, suffixes, actions, namemaps, null, null);
//						main.createRequestListener();
//					}
//
//					main.showMessage(Locale.getString(this, Locale.DONE), Locale.getString(this, Locale.OPERATION_OK), AlertType.INFO, 1500, typelist);
//				}
//				catch(Throwable t)
//				{
//					t.printStackTrace();
//					main.showMessage(Locale.getString(this, Locale.ERROR), t.toString(), AlertType.ERROR, 3000, typelist);
//				}
//			}
//			else if(c == cmdSelectAll)
//			{
//				boolean[] flags = new boolean[typelist.size()];
//
//				for(int i = 0; i < flags.length; i++)
//				{
//					flags[i] = true;
//				}
//
//				typelist.setSelectedFlags(flags);
//			}
//			else if(c == cmdDeselectAll)
//			{
//				boolean[] flags = new boolean[typelist.size()];
//
//				for(int i = 0; i < flags.length; i++)
//				{
//					flags[i] = false;
//				}
//
//				typelist.setSelectedFlags(flags);
//			}
//			else
//			{
//				main.dsp.setCurrent(this);
//			}
//		}
		else if(d == fontForm)
		{
			if(c.getCommandType() == Command.OK)
			{
				siSelectedFont.setText(fontForm.toString().toLowerCase());

				AbstractFont font = fontForm.getFont();

				if(font instanceof GraphicFont)
				{
					siInstalledFont.setText(((GraphicFont)font).getName() + " " + ((GraphicFont)font).getSizeInPoints());
				}
				else
				{
					siInstalledFont.setText(Locale.getString(this, Locale.DEVICE_FONT));
				}

				tfFontPath.setString(fontConfig.fontpaths[font.getIndex()]);

				main.dsp.setCurrent(frmFontSetup);
			}
			else
			{
				main.dsp.setCurrent(this);
			}
		}
		else if(d == frmFontSetup)
		{
			if(c.getCommandType() == Command.OK)
			{
				fontConfig.fontpaths[fontForm.getFontIndex()] = tfFontPath.getString();
				fontConfig.saveFonts();
				
				restart_flag = true;
			}

			main.dsp.setCurrent(fontForm);
		}
		else if(d == passForm)
		{
			main.dsp.setCurrent(this);
		}
		else if(d == tbPassword)
		{
			if(c.getCommandType() == Command.OK)
			{
				md.update(StringEncoder.encodeString(tbPassword.getString(), StringEncoder.ENC_DEFAULT));

				switch(passwordFor)
				{
					case 0:
						options.launchPasswordHash = HashUtil.toString(md.digest());
						break;

					case 1:
						options.optionsPasswordHash = HashUtil.toString(md.digest());
						break;
				}

				updatePasswordLabels();
			}

			main.dsp.setCurrent(passForm);
		}
		else
		{
			if(c.getCommandType() == Command.OK)
			{
				main.loader.restartApp();
			}
			else
			{
				cvsWait.start(main.FileSelect, main.currentFile);
			}
		}
	}

	public void commandAction(Command c, Item item)
	{
		if(item == siLaunchPassword)
		{
			passwordFor = 0;
			tbPassword.setString("");
			main.dsp.setCurrent(tbPassword);
		}
		else if(item == siOptionsPassword)
		{
			passwordFor = 1;
			tbPassword.setString("");
			main.dsp.setCurrent(tbPassword);
		}
	}
	
	/**
	 * Обработчик переключения состояния элемента
	 */
	public void itemStateChanged(Item item)
	{
		if(item == cgLang ||
		   item == cgLargeFont)
		{
			restart_flag = true;
		}
		else if(item == cgColorScheme)
		{
			if(cgColorScheme.getSelectedIndex() == cgColorScheme.size() - 1)
			{
				main.showColorSchemeEditor(this);
			}
		}
	}
}
