package filemanager; // переведен

import com.vmx.Locale;
import javax.microedition.lcdui.*;
import com.vmx.AuxClass;

public class frmProperties extends Form implements CommandListener
{
	private Object parent;

	private ChoiceGroup cgAttrib;
	private boolean hidden, readonly;

	private Command cmdPropOK = new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1);
	private Command cmdPropBack = new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.BACK, 1);
	
	/**
	 * Конструктор
	 */
	public frmProperties(Object parent)
	{
		super("");
		setTitle(Locale.getString(this, Locale.INFORMATION));
		
		this.parent = parent;

		String tmp = main.currentPath;
		
		if("fav:/".equals(tmp))
		{
			tmp = "";
		}
		
		if(!main.currentFile.equalsIgnoreCase(".."))
		{
			tmp += main.currentFile;
		}
		
		// Значок файла или папки
		/*
		if(filesystem.isDir(tmp))
		{
			if(filesystem.isHidden(tmp))
			{
				append(images.getIcon(images.iHiddenFolder));
			}
			else
			{
				append(images.getIcon(images.iFolder));
			}
		}
		else
		{
			append(images.getIcon(filesystem.typeIcon(filesystem.fileType(tmp))));
		}
		
		append("\n");
		*/
		
		String s;
		boolean isdir = filesystem.isDir(tmp);
		
		// Имя
		if(isdir)
		{
			append(new TextField(Locale.getString(this, Locale.FOLDER_NAME), tmp, tmp.length(), TextField.ANY));
		}
		else
		{
			append(new TextField(Locale.getString(this, Locale.FILE_NAME), tmp, tmp.length(), TextField.ANY));
		}
		
		// Размер
		long size = filesystem.getSize(tmp, true); // options.checkFileAttrib);

		if(size < 0)
		{
			size = filesystem.getSize(tmp, false);
		}

		if(size >= 0)
		{
			s = filesystem.getSizeString(size, true);
			append(new TextField(Locale.getString(this, Locale.SIZE), s, s.length(), TextField.ANY));
		}

		// Сжатый размер
		long compsize = filesystem.getCompressedSize(tmp);

		if(compsize >= 0)
		{
			s = filesystem.getSizeString(compsize, true);
			append(new TextField(Locale.getString(this, Locale.COMPRESSED_SIZE), s, s.length(), TextField.ANY));
		}

		// Посл изм.
		long time = filesystem.lastModified(tmp);

		if(time > 0)
		{
			s = AuxClass.timeToString(time, false);
			append(new TextField(Locale.getString(this, Locale.LAST_MODIF), s, s.length(), TextField.ANY));
		}

		// Счетчик файлов
		if(isdir) // && options.checkFileAttrib)
		{
			int[] count = filesystem.getFileCount(tmp, options.showHidden);
			s = Locale.getString(this, Locale.CONTENTS_PATTERN, new String[] { Integer.toString(count[0]), Integer.toString(count[1]) });
			append(new TextField(Locale.getString(this, Locale.CONTENTS), s, s.length(), TextField.ANY));
		}

		// Attributes
		if(!main.currentFile.equalsIgnoreCase(".."))
		{
			cgAttrib = new ChoiceGroup(Locale.getString(this, Locale.ATTR), ChoiceGroup.MULTIPLE);

			cgAttrib.append(Locale.getString(this, Locale.ATTR_READ_ONLY), null);
			readonly = filesystem.isReadOnly(tmp);
			cgAttrib.setSelectedIndex(0, readonly);

			if(true) // options.showHidden)
			{
				cgAttrib.append(Locale.getString(this, Locale.ATTR_HIDDEN), null);
				hidden = filesystem.isHidden(tmp);
				cgAttrib.setSelectedIndex(1, hidden);
			}

			append(cgAttrib);
		}
		
		if(cgAttrib != null)
		{
			addCommand(cmdPropOK);
		}
		
		addCommand(cmdPropBack);
		setCommandListener(this);
	}

	public void commandAction(Command command, Displayable displayable)
	{
		// Команда ОК - изменяем свойства файла или папки
		if(command == cmdPropOK)
		{
			if((readonly != cgAttrib.isSelected(0)) || (hidden != cgAttrib.isSelected(1)))
			{
				filesystem.setReadOnly(main.currentPath + main.currentFile, cgAttrib.isSelected(0));
				filesystem.setHidden(main.currentPath + main.currentFile, cgAttrib.isSelected(1));
				
				main.FileSelect.updateFileType(main.FileSelect.getSelectedIndex());
			}
			
			main.dsp.setCurrent(parent);
		}
		// НАЗАД - ВЫХОД ИЗ ОКНА СВОЙСТВ
		else if(command == cmdPropBack)
		{
			main.dsp.setCurrent(parent);
		}
	}
	
//	private static void out(String s)
//	{
//		System.out.println("[frmProperties] " + s);
//	}
}
