package filemanager;

import com.vmx.Locale;
import javax.microedition.lcdui.*;
import com.one.StringPattern;

public class frmSearch extends Form implements CommandListener
{
	protected Object parent;
	
	protected TextField tfText;
	protected ChoiceGroup cgSearchIn, cgOptions;
	
	public frmSearch(Object p)
	{
		super("");
		setTitle(Locale.getString(this, Locale.MENU_SEARCH));
		
		parent = p;
		
		tfText = new TemplateTextField(Locale.getString(this, Locale.FIND_CMD), "", 256, TextField.ANY);

		cgSearchIn = new ChoiceGroup(null, Choice.EXCLUSIVE);
		cgSearchIn.append(Locale.getString(this, Locale.SEARCH_CURRENT_FOLDER), null);
		cgSearchIn.append(Locale.getString(this, Locale.SEARCH_CURRENT_DISK), null);
		cgSearchIn.append(Locale.getString(this, Locale.SEARCH_ALL_DISKS), null);
		
		cgOptions = new ChoiceGroup(null, Choice.MULTIPLE);
		cgOptions.append(Locale.getString(this, Locale.IGNORE_CASE), null);
		cgOptions.append(Locale.getString(this, Locale.RECURSIVE_SEARCH), null);
		cgOptions.append(Locale.getString(this, Locale.SEARCH_INSIDE_ARCHIVES), null);
		
		append(tfText);
		append(cgSearchIn);
		append(cgOptions);
		
		addCommand(new Command(Locale.getString(this, Locale.FIND_CMD), Command.OK, 1));
		addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 2));
		
		setCommandListener(this);
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		main.dsp.setCurrent(parent);
		
		if(c.getCommandType() == Command.OK)
		{
			String path;

			if(cgSearchIn.isSelected(0))
			{
				path = main.currentPath;
			}
			else if(cgSearchIn.isSelected(1))
			{
				path = main.currentPath.substring(0, main.currentPath.indexOf('/') + 1);
			}
			else
			{
				path = "";
			}

			Buffer.startOperation(new SearchThread(new StringPattern(tfText.getString(), cgOptions.isSelected(0)), path, cgOptions.isSelected(1), cgOptions.isSelected(2)));
		}
	}
}
