package filemanager;

import com.one.IniFile;
import com.one.PaintableObject;
import com.one.Renderer;
import com.vmx.Locale;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class lstColorScheme extends List implements CommandListener
{
	public Object parent;

	protected Palette palette;
	protected ColorSelector selector;

	protected int index;
	protected IniFile clocnames;

	public lstColorScheme()
	{
		super(null, IMPLICIT);
		setTitle(Locale.getString(this, Locale.COLOR_SCHEME));

		palette = new Palette();
		selector = new ColorSelector();

		palette.setCommandListener(this);
		selector.setCommandListener(this);

		selector.setInteractive(!options.noEffects);

		try
		{
			clocnames = new IniFile("/lang/" + Locale.lang + "/colors.ini", true);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		setCommandListener(this);
	}

	public void updateList()
	{
		if(size() > 0)
		{
			index = getSelectedIndex();
		}

		deleteAll();

		if(clocnames != null)
		{
			String clocname;

			for(int i = 0; i < ColorScheme.colors.length; i++)
			{
				clocname = clocnames.getRecord(null, ColorScheme.cnames[i]);
				append(clocname != null ? clocname : ColorScheme.cnames[i], images.createColorSample(ColorScheme.colors[i], images.iconWidth, images.iconHeight));
			}
		}
		else
		{
			for(int i = 0; i < ColorScheme.colors.length; i++)
			{
				append(ColorScheme.cnames[i], images.createColorSample(ColorScheme.colors[i], images.iconWidth, images.iconHeight));
			}
		}

		setSelectedIndex(index, true);
	}

	public void commandAction(Command c, Displayable dp)
	{
		if(dp == this)
		{
			if(c == SELECT_COMMAND)
			{
				index = getSelectedIndex();

				if(palette.setColor(ColorScheme.colors[index]))
				{
					main.dsp.setCurrent(palette);
				}
				else
				{
					selector.setColor(ColorScheme.colors[index]);
					main.dsp.setCurrent(selector);
				}
			}
			else
			{
				//main.FileSelect.updateGradients();
				main.dsp.setCurrent(parent);
			}
		}
		else if(dp instanceof Renderer)
		{
			PaintableObject po = ((Renderer)dp).getCurrent();

			if(po == palette)
			{
				switch(c.getCommandType())
				{
					case Command.OK:
						ColorScheme.colors[getSelectedIndex()] = palette.getColor();
						updateList();
						main.dsp.setCurrent(this);
						break;

					case Command.ITEM:
						selector.setColor(palette.getColor());
						main.dsp.setCurrent(selector);
						break;

					case Command.CANCEL:
						main.dsp.setCurrent(this);
						break;
				}
			}
			else if(po == selector)
			{
				switch(c.getCommandType())
				{
					case Command.OK:
						ColorScheme.colors[getSelectedIndex()] = selector.getColor();
						updateList();
						main.dsp.setCurrent(this);
						break;

					case Command.ITEM:
						palette.setColor(selector.getColor());
						main.dsp.setCurrent(palette);
						break;

					case Command.CANCEL:
						main.dsp.setCurrent(this);
						break;
				}
			}
		}
	}
}
