package filemanager;

import com.one.ErrScreen;
import com.one.file.TransparentConnector;
import com.vmx.Locale;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class lstContainers extends ListMenu implements CommandListener, ListStateListener
{
	public Object parent;

	protected Vector containers;
	protected Vector usecounts;
	protected Vector depcounts;

	protected Command cmdClose = new Command(Locale.getString(this, Locale.CLOSE_CMD), Command.OK, 1);
	protected Command cmdCloseAll = new Command(Locale.getString(this, Locale.CLOSE_ALL_CMD), Command.OK, 2);
	protected Command cmdBack = new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 3);

	public lstContainers()
	{
		//super(null, MULTIPLE);
		setTitle(Locale.getString(this, Locale.CONTAINERS));

		containers = new Vector();
		usecounts = new Vector();
		depcounts = new Vector();

		addCommand(cmdClose);
		//addCommand(cmdCloseAll);
		addCommand(cmdBack);
		setCommandListener(this);
		setStateListener(this);

		updateList();
	}

	public void updateList()
	{
		containers.removeAllElements();
		usecounts.removeAllElements();
		depcounts.removeAllElements();

		Enumeration contnames = TransparentConnector.listContainers();
		String contname;
		Integer usecount;
		Integer depcount;
		boolean added;

		while(contnames.hasMoreElements())
		{
			contname = (String)contnames.nextElement();
			usecount = new Integer(TransparentConnector.getUseCount(contname));
			depcount = new Integer(TransparentConnector.getDependentCount(contname));

			added = false;

			for(int i = 0; i < usecounts.size(); i++)
			{
				if(usecount.intValue() >= ((Integer)usecounts.elementAt(i)).intValue())
				{
					containers.insertElementAt(contname, i);
					usecounts.insertElementAt(usecount, i);
					depcounts.insertElementAt(depcount, i);

					added = true;

					break;
				}
			}

			if(!added)
			{
				containers.addElement(contname);
				usecounts.addElement(usecount);
				depcounts.addElement(depcount);
			}
		}

		deleteAll();

		for(int i = 0; i < containers.size(); i++)
		{
			contname = (String)containers.elementAt(i);

			contname = contname.substring(0, contname.length() - 1);
			//contname = contname.substring(contname.lastIndexOf('/') + 1);
			
			append(contname); // + " (" + ((Integer)usecounts.elementAt(i)).toString() + ")"); //, null);
		}
	}

	public void commandAction(Command c, Displayable dp)
	{
		if(c == cmdClose || c == List.SELECT_COMMAND)
		{
			if(size() > 0)
			{
				//main.dsp.setCurrent(parent);
				//main.dsp.setRenderMode();

				try
				{
					TransparentConnector.closeContainer((String)containers.elementAt(getSelectedIndex()));
				}
				catch(IOException e)
				{
					ErrScreen.showErrMsg(136, e);
				}

				updateList();
				//main.dsp.setCurrent(this);
			}
		}
		else if(c == cmdCloseAll)
		{
			if(size() > 0)
			{
				//main.dsp.setCurrent(parent);
				//main.dsp.setRenderMode();

				try
				{
					TransparentConnector.closeContainers();
				}
				catch(IOException e)
				{
					ErrScreen.showErrMsg(136, e);
				}

				updateList();
				//main.dsp.setCurrent(this);
			}
		}
		else if(c == cmdBack)
		{
			main.dsp.setCurrent(parent);
		}
	}

	public void listStateChanged(ListMenu list, int action)
	{
		if(list.size() > 0)
		{
			int index = list.getSelectedIndex();

			String[] tokens = new String[]
			{
				((Integer)usecounts.elementAt(index)).toString(),
				((Integer)depcounts.elementAt(index)).toString(),
			};

			list.setSubTitle(Locale.getString(this, Locale.CONTAINER_INFO, tokens), false);
		}
		else
		{
			list.setSubTitle("", false);
		}
	}
}
