package filemanager;

import com.vmx.Locale;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class lstPanels extends ListMenu implements CommandListener, ListStateListener
{
	protected Object parent;

	public lstPanels(Object parent)
	{
		setTitle(Locale.getString(this, Locale.PANELS));

		this.parent = parent;

		addCommand(new Command(Locale.getString(this, Locale.OPEN_CMD), Command.OK, 1));
		addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 2));

		setCommandListener(this);
		setStateListener(this);

		updateList();
	}

	public void updateList()
	{
		main.manager.storePanel(main.manager.currentPanel());
		
		deleteAll();

		int pcount = main.manager.panelsCount();
		String filename;

		for(int i = 0; i < pcount; i++)
		{
			filename = main.manager.getCurrentFileName(i);

			if(filename.length() == 0)
			{
				filename = Locale.getString(this, Locale.ROOT);
			}

			//append(Integer.toString(i + 1) + " - " + filename);
			append(filename);
		}

		setSelectedIndex(main.manager.currentPanel());
	}

	public void commandAction(Command c, Displayable dp)
	{
		main.dsp.setCurrent(parent);
		
		if(c.getCommandType() == Command.OK)
		{
			main.manager.changePanel(getSelectedIndex());
		}
	}

	public void listStateChanged(ListMenu list, int action)
	{
		if(size() > 0)
		{
			String pname = main.manager.getPanelName(getSelectedIndex());

			if(pname.length() > 0)
			{
				setSubTitle(pname, false);
			}
			else
			{
				setSubTitle(Locale.getString(this, Locale.FILE_LIST), false);
			}
		}
	}
}
