package mcp;

import com.one.file.ConnectionProvider;
import com.one.file.FileConnection;
import com.one.file.GenericFileConnection;
import com.vmx.AuxClass;
import java.util.Enumeration;
import javax.microedition.io.Connection;

public class MultiConnectionProvider implements ConnectionProvider
{
	static final int API_UNKNOWN = 0;
	static final int API_GENERIC = 1;
	static final int API_SIEMENS = 2;
	static final int API_MOTOROLA_TYPE_A = 3;
	static final int API_MOTOROLA_TYPE_B = 4;

	private static int apitype = -1;

	private static void detectApiType()
	{
		//#if JSR75 == "auto"

		if(AuxClass.classExists("javax.microedition.io.file.FileConnection"))
		{
			apitype = API_GENERIC;
		}
		else if(AuxClass.classExists("com.siemens.mp.io.file.FileConnection"))
		{
			apitype = API_SIEMENS;
		}
		else if(AuxClass.classExists("com.motorola.io.FileConnection"))
		{
			apitype = API_MOTOROLA_TYPE_A;
		}
		else if(AuxClass.classExists("com.motorola.io.file.FileConnection"))
		{
			apitype = API_MOTOROLA_TYPE_B;
		}
		else
		{
			apitype = API_UNKNOWN;
		}

		//#else
//#
//# 		apitype = API_GENERIC;
//#
		//#endif
	}

	private static int getApiType()
	{
		if(apitype < 0)
		{
			detectApiType();
		}

		return apitype;
	}

	public Enumeration listRoots()
	{
		//#if JSR75 == "auto"

		switch(getApiType())
		{
			case API_GENERIC:
				return GenericFileConnection.listRoots();

			case API_SIEMENS:
				return SiemensFileConnection.listRoots();

			case API_MOTOROLA_TYPE_A:
				return MotorolaTypeAFileConnection.listRoots();

			case API_MOTOROLA_TYPE_B:
				return MotorolaTypeBFileConnection.listRoots();

			default:
				return null;
		}

		//#else
//#
//# 		return GenericFileConnection.listRoots();
//#
		//#endif
	}

	public FileConnection convertFileConnection(Connection conn)
	{
		//#if JSR75 == "auto"

		switch(getApiType())
		{
			case API_GENERIC:
				return new GenericFileConnection(conn);

			case API_SIEMENS:
				return new SiemensFileConnection(conn);

			case API_MOTOROLA_TYPE_A:
				return new MotorolaTypeAFileConnection(conn);

			case API_MOTOROLA_TYPE_B:
				return new MotorolaTypeBFileConnection(conn);

			default:
				return null;
		}

		//#else
//#
//# 		return new GenericFileConnection(conn);
//#
		//#endif
	}
}
