package modules;

import com.one.Application;
import com.one.ModuleRegistry;
import com.one.PlayList;
import com.vmx.Locale;
import filemanager.GraphicAlert;
import filemanager.fontConfig;
import filemanager.frmFont;
import filemanager.images;
import filemanager.main;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class FontModule implements Application, CommandListener
{
	protected Object parent;
	protected String filename;

	protected frmFont fontForm;
	protected static int index;

	public void openFile(String filename, PlayList filelist)
	{
		this.filename = filename;

		fontForm = new frmFont(ModuleRegistry.getModuleName(getClass().getName()));

		fontForm.addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		fontForm.addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.CANCEL, 2));
		fontForm.setCommandListener(this);

		fontForm.setFontIndex(index);

		parent = main.dsp.getCurrent();
		main.dsp.setCurrent(fontForm);
	}

	public void commandAction(Command c, Displayable dp)
	{
		if(dp == fontForm)
		{
			if(c.getCommandType() == Command.OK)
			{
				fontConfig.fontpaths[index = fontForm.getFontIndex()] = filename;
				fontConfig.saveFonts();

				GraphicAlert alert = new GraphicAlert(Locale.getString(this, Locale.ATTENTION), Locale.getString(this, Locale.NEED_RESTART), images.getAlertIcon(AlertType.CONFIRMATION), AlertType.CONFIRMATION);

				alert.addCommand(new Command(Locale.getString(this, Locale.YES_CMD), Command.OK, 1));
				alert.addCommand(new Command(Locale.getString(this, Locale.NO_CMD), Command.CANCEL, 2));
				alert.setCommandListener(this);

				main.dsp.setCurrent(alert);
			}
			else
			{
				main.dsp.setCurrent(parent);
			}
		}
		else
		{
			if(c.getCommandType() == Command.OK)
			{
				main.loader.restartApp();
			}
			else
			{
				main.dsp.setCurrent(parent);
			}
		}
	}
}