package modules;

import com.one.ErrScreen;
import com.one.FileSource;
import com.one.ModuleRegistry;
import com.one.TextProcessor;
import com.vmx.Locale;
import filemanager.filesystem;
import filemanager.main;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.TextField;

public class NullFileSource implements FileSource, CommandListener
{
	protected Object parent;
	protected String filename;

	protected TextField tfByte;
	protected TextField tfLength;

	public void createFile(String filename)
	{
		this.filename = filename;

		Form form = new Form(ModuleRegistry.getModuleName(getClass().getName()));

		tfByte = new TextField(Locale.getString(this, Locale.CHARACTER), "\\0", 6, TextField.ANY);
		tfLength = new TextField(Locale.getString(this, Locale.SIZE), "0", 20, TextField.NUMERIC);

		form.append(tfByte);
		form.append(tfLength);

		form.addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		form.addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.CANCEL, 1));
		form.setCommandListener(this);

		parent = main.dsp.getCurrent();
		main.dsp.setCurrent(form);
	}

	public void commandAction(Command c, Displayable dp)
	{
		if(c.getCommandType() == Command.OK)
		{
			try
			{
				filesystem.makeNewFile(filename, TextProcessor.unescapeString(tfByte.getString()), Integer.parseInt(tfLength.getString()));
				main.FileSelect.showWait(filename.substring(filename.lastIndexOf('/') + 1));
			}
			catch(Exception e)
			{
				ErrScreen.showErrMsg(ModuleRegistry.getErrCode(getClass().getName()) * 100 + 1, e);
			}
		}
		else
		{
			main.dsp.setCurrent(parent);
		}
	}
}