package modules.audio;

import com.vmx.AuxClass;
import com.vmx.Locale;
import filemanager.main;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.control.audioeffect.EqualizerControl;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;

/**
 * Эквалайзер.
 */
public class EqualizerForm extends Form implements CommandListener, ItemStateListener
{
	protected Object parent;
	protected EqualizerControl equalizer;
	protected Gauge[] bands;
	protected Integer[] frequencies;
	protected String[] labels;
	protected int minlevel, maxlevel;
	protected int maxgauge;

	public EqualizerForm(Object parent) throws ClassNotFoundException
	{
		super("");
		setTitle(Locale.getString(this, Locale.EQUALIZER));

		this.parent = parent;

		if(!AuxClass.classExists("javax.microedition.amms.control.audioeffect.EqualizerControl"))
		{
			throw new ClassNotFoundException();
		}

		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		setCommandListener(this);
		setItemStateListener(this);
	}

	public void init()
	{
		if(equalizer != null)
		{
			return;
		}

		equalizer = (EqualizerControl)GlobalManager.getControl("javax.microedition.amms.control.audioeffect.EqualizerControl");

		if(equalizer == null)
		{
			return;
		}

		equalizer.setEnabled(true);

		minlevel = equalizer.getMinBandLevel();
		maxlevel = equalizer.getMaxBandLevel();

		maxgauge = (maxlevel - minlevel) / 100;

		bands = new Gauge[equalizer.getNumberOfBands()];
		frequencies = new Integer[bands.length];
		labels = new String[bands.length];

		Integer level;

		for(int i = 0; i < bands.length; i++)
		{
			frequencies[i] = new Integer(equalizer.getCenterFreq(i));
			level = (Integer)AudioOptions.eqlevels.get(frequencies[i]);

			if(level != null)
			{
				equalizer.setBandLevel(level.intValue(), i);
			}
			else
			{
				AudioOptions.eqlevels.put(frequencies[i], level = new Integer(equalizer.getBandLevel(i)));
			}

			labels[i] = (frequencies[i].intValue() >= 1000000 ? (Integer.toString(frequencies[i].intValue() / 1000000) + ((frequencies[i].intValue() / 1000) % 1000 > 0 ? ("." + Integer.toString((frequencies[i].intValue() / 1000) % 1000)) : "") + " " + Locale.getString(this, Locale.KHZ)) : (Integer.toString(frequencies[i].intValue() / 1000) + " " + Locale.getString(this, Locale.HZ))) + ": ";
			bands[i] = new Gauge(labels[i] + (level.intValue() >= 0 ? "+" : "") + Integer.toString(level.intValue() / 100) + " " + Locale.getString(this, Locale.DB), true, maxgauge, (level.intValue() - minlevel) * maxgauge / (maxlevel - minlevel));

			append(bands[i]);
		}
	}

	public void itemStateChanged(Item item)
	{
		for(int i = 0; i < bands.length; i++)
		{
			if(item == bands[i])
			{
				int level = minlevel + (maxlevel - minlevel) * bands[i].getValue() / maxgauge;

				bands[i].setLabel(labels[i] + (level >= 0 ? "+" : "") + Integer.toString(level / 100) + " " + Locale.getString(this, Locale.DB));
				equalizer.setBandLevel(level, i);

				AudioOptions.eqlevels.put(frequencies[i], new Integer(level));

				break;
			}
		}
	}

	public void commandAction(Command c, Displayable dp)
	{
		main.dsp.setCurrent(parent);
	}
}