package modules.cfs;

import com.one.ArchiveContainer;
import com.one.FileSource;
import filemanager.main;
import java.io.IOException;
import org.apache.commons.compress.compressors.bzip2.BZip2Archive;

public class BZipFileSource implements FileSource
{
	public void createFile(String filename) throws IOException
	{
		ArchiveContainer container = new BZip2Archive();

		container.init(filename, true);
		container.close();

		main.FileSelect.showWait(filename.substring(filename.lastIndexOf('/') + 1));
	}
}
