package modules.color;

import com.one.BufferedInputStream;
import com.one.FileSource;
import com.one.PlainPackage;
import filemanager.ColorScheme;
import filemanager.main;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ColorFileSource implements FileSource
{
	public void createFile(String filename) throws IOException
	{
		PlainPackage ppk = new PlainPackage();
		ppk.init(filename, true);

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ColorScheme.saveColorScheme(baos);

		byte[] data = baos.toByteArray();
		baos.close();

		ppk.addEntry(new BufferedInputStream(data), "scheme.ini", -1, true, null);

		ppk.close();

		main.FileSelect.showWait(filename.substring(filename.lastIndexOf('/') + 1));
	}
}
