package modules.color;

import com.one.Application;
import com.one.PlainPackage;
import com.one.PlayList;
import com.one.ProgressBar;
import com.one.TextProcessor;
import com.one.file.Connector;
import com.one.file.FileConnection;
import com.vmx.Locale;
import com.vmx.ProgressCallback;
import filemanager.ColorScheme;
import filemanager.main;
import filemanager.options;
import java.io.DataInputStream;
import java.io.IOException;

public class ColorModule implements Application
{
	public void openFile(String filename, PlayList filelist) throws IOException
	{
		options.colorScheme = ColorScheme.SCHEME_CUSTOM;

		FileConnection fc = (FileConnection)Connector.open("file:///" + filename);
		DataInputStream dis = fc.openDataInputStream();

		byte[] sig = new byte[3];
		dis.readFully(sig);

		String s = TextProcessor.byteArrayToString(sig);

		if(s.equals("MCS") || s.equals("Ths"))
		{
			ColorScheme.loadLegacyColorScheme(dis);

			dis.close();
			fc.close();

			if(main.dsp.getCurrent() != main.FileSelect)
			{
				main.dsp.setCurrent(main.FileSelect);
			}

			//main.FileSelect.updateGradients();
			main.FileSelect.repaint();
		}
		else
		{
			dis.close();
			fc.close();

			ProgressCallback callback = ProgressBar.getProgressCallback();
			callback.setProgress(0);
			callback.setText(Locale.getString(getClass().getName(), Locale.INSTALLING_COLOR_SCHEME));

			PlainPackage ppk = new PlainPackage();
			ppk.init(filename, false);

			if(ColorScheme.loadModernColorScheme(ppk))
			{
				//main.FileSelect.updateGradients();
				main.FileSelect.updateModuleList();
				main.FileSelect.showWait(main.currentFile);
			}
			else
			{
				if(main.dsp.getCurrent() != main.FileSelect)
				{
					main.dsp.setCurrent(main.FileSelect);
				}

				//main.FileSelect.updateGradients();
				main.FileSelect.repaint();
			}

			ppk.close();
		}
	}

	
}
