package modules.convert;

import com.one.ModuleRegistry;
import com.one.OptionStorage;
import com.vmx.Locale;
import filemanager.main;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.AlertType;

public class PNGOptions implements OptionStorage
{
	public static final int OPTIONS_VERSION = 2;

	public static int numColors = PNGConverter.MAX_COLORS;
	public static boolean quantize = false;
	public static boolean dither = false;
	public static int imageType = 0;
	public static int filterType = 0;

	public void showEditor(Object parent)
	{
		main.showMessage(Locale.getString(this, Locale.INFORMATION), Locale.getString(this, Locale.NO_STANDALONE_OPTIONS), AlertType.INFO, 3000, parent);
	}

	public void restoreOptions()
	{
		try
		{
			byte[] data = ModuleRegistry.getModuleData(getClass().getName());

			if(data == null || data.length == 0)
			{
				return;
			}

			DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));

			if(dis.readInt() != OPTIONS_VERSION)
			{
				dis.close();
				return;
			}

			numColors = dis.readInt();
			quantize = dis.readBoolean();
			dither = dis.readBoolean();
			imageType = dis.readInt();
			filterType = dis.readInt();

			dis.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	public void saveOptions()
	{
		try
		{
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			DataOutputStream dos = new DataOutputStream(baos);

			dos.writeInt(OPTIONS_VERSION);
			dos.writeInt(numColors);
			dos.writeBoolean(quantize);
			dos.writeBoolean(dither);
			dos.writeInt(imageType);
			dos.writeInt(filterType);

			byte[] data = baos.toByteArray();
			dos.close();

			ModuleRegistry.setModuleData(getClass().getName(), data);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
}