package modules.image;

import com.one.ExtGraphics;
import com.one.ImageProcessor;
import com.one.vector.VectorImage;
import filemanager.images;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public interface ImageContainer
{
	public int getWidth();
	public int getHeight();

	public void scale(int width, int height);
	public void paint(ExtGraphics g, int x, int y, int transform);

	public long getFrameDelay();
	public int currentFrame();
	public void gotoFrame(int target);
	public boolean nextFrame();
	public boolean prevFrame();

	public boolean isNull();
	public Image getGenericImage();
}

class TestImageContainer implements ImageContainer
{
	protected Image image;

	public TestImageContainer()
	{
		scale(768, 576);
	}

	public int getWidth()
	{
		return image.getWidth();
	}

	public int getHeight()
	{
		return image.getHeight();
	}

	public void scale(int width, int height)
	{
		image = Image.createImage(width, height);
		Graphics g = image.getGraphics();

		g.setColor(0xFF000000);
		g.fillRect(0, 0, width, height);

		images.drawVColorTest(g, 0, 0, width, height);

		g.setColor(0xFFFFFFFF);
		g.drawRect(0, 0, width - 1, height - 1);
	}

	public void paint(ExtGraphics g, int x, int y, int transform)
	{
		g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), transform, x, y, Graphics.LEFT | Graphics.TOP);
	}

	public long getFrameDelay()
	{
		return 0;
	}

	public int currentFrame()
	{
		return 0;
	}

	public void gotoFrame(int target)
	{
	}

	public boolean nextFrame()
	{
		return false;
	}

	public boolean prevFrame()
	{
		return false;
	}

	public boolean isNull()
	{
		return image == null;
	}

	public Image getGenericImage()
	{
		return image;
	}
}

class GenericImageContainer implements ImageContainer
{
	protected Image image;

	public GenericImageContainer(Image image)
	{
		this.image = image;
	}

	public int getWidth()
	{
		return image.getWidth();
	}

	public int getHeight()
	{
		return image.getHeight();
	}

	public void scale(int width, int height)
	{
		image = ImageProcessor.scaleImage(image, width, height, false, true);
	}

	public void paint(ExtGraphics g, int x, int y, int transform)
	{
		g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), transform, x, y, Graphics.LEFT | Graphics.TOP);
	}

	public long getFrameDelay()
	{
		return 0;
	}

	public int currentFrame()
	{
		return 0;
	}

	public void gotoFrame(int target)
	{
	}

	public boolean nextFrame()
	{
		return false;
	}

	public boolean prevFrame()
	{
		return false;
	}

	public boolean isNull()
	{
		return image == null;
	}

	public Image getGenericImage()
	{
		return image;
	}
}

class VectorImageContainer implements ImageContainer
{
	protected VectorImage image;

	public VectorImageContainer(VectorImage image)
	{
		this.image = image;
	}

	public int getWidth()
	{
		return image.getWidth();
	}

	public int getHeight()
	{
		return image.getHeight();
	}

	public void scale(int width, int height)
	{
		image.scale(width, height);
	}

	public void paint(ExtGraphics g, int width, int height, int transform)
	{
		image.paint(g.getGraphics(), width, height);
	}

	public long getFrameDelay()
	{
		return image.getFrameDelay();
	}

	public int currentFrame()
	{
		return image.currentFrame();
	}

	public void gotoFrame(int target)
	{
		image.gotoFrame(target);
	}

	public boolean nextFrame()
	{
		return image.nextFrame();
	}

	public boolean prevFrame()
	{
		return image.prevFrame();
	}

	public boolean isNull()
	{
		return image == null;
	}

	public Image getGenericImage()
	{
		try
		{
			Image offscreen = Image.createImage(image.getWidth(), image.getHeight());
			Graphics offgraphics = offscreen.getGraphics();

			image.paint(offgraphics, 0, 0);

			return offscreen;
		}
		catch(Throwable t)
		{
			return null;
		}
	}
}