package modules.langpack;

import com.one.Application;
import com.one.IniFile;
import com.one.PlayList;
import com.one.TextProcessor;
import com.one.file.Connector;
import com.one.file.FileConnection;
import com.vmx.OutputStreamEncoder;
import com.vmx.StringEncoder;
import java.io.DataInputStream;
import java.io.IOException;

public class StringUnpacker implements Application
{
	public void openFile(String filename, PlayList filelist) throws IOException
	{
		FileConnection fc = (FileConnection)Connector.open("file:///" + filename);

		String tempname = Connector.createTempFile(filename, true);
		FileConnection temp = (FileConnection)Connector.open("file:///" + tempname);
		temp.create();

		DataInputStream dis = fc.openDataInputStream();
		IniFile ini = new IniFile(false);

		int count = dis.readInt();
		String section = Integer.toString(count);

		for(int i = 0; i < count; i++)
		{
			ini.addRecord(section, Integer.toString(i), TextProcessor.escapeString(dis.readUTF(), StringEncoder.ENC_UTF8));
		}

		dis.close();

		OutputStreamEncoder ose = new OutputStreamEncoder(temp.openOutputStream(), StringEncoder.ENC_UTF8);
		ini.write(ose);
		ose.close();

		filename = fc.getName();
		fc.delete();
		fc.close();

		temp.rename(filename);
		temp.close();

		Connector.releaseTempFile(tempname);
	}
}
