package modules.playlist;

import com.one.ErrScreen;
import com.one.FileSource;
import com.one.ModuleRegistry;
import com.one.file.Connector;
import com.one.file.FileConnection;
import com.vmx.AuxClass;
import com.vmx.Locale;
import com.vmx.OutputStreamEncoder;
import com.vmx.StringEncoder;
import filemanager.Buffer;
import filemanager.main;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

public class M3UFileSource implements FileSource, CommandListener
{
	protected Object parent;
	protected String filename;

	protected ChoiceGroup cgType;

	public void createFile(String filename) throws IOException
	{
		this.filename = filename;

		Form form = new Form(ModuleRegistry.getModuleName(getClass().getName()));

		cgType = new ChoiceGroup(/* Locale.getString(this, Locale.FILE_TYPE) */ null, Choice.EXCLUSIVE);

		Enumeration groups = ModuleRegistry.listSimalarityGroups();
		String group;

		while(groups.hasMoreElements())
		{
			group = (String)groups.nextElement();
			cgType.append(group, ModuleRegistry.getIcon((String)ModuleRegistry.listSimilars(group).nextElement()));
		}

		cgType.setSelectedIndex(0, true);

		form.append(cgType);

		form.addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		form.addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.CANCEL, 2));
		form.setCommandListener(this);

		parent = main.dsp.getCurrent();
		main.dsp.setCurrent(form);
	}

	public void commandAction(Command c, Displayable dp)
	{
		if(c.getCommandType() == Command.OK)
		{
			try
			{
				if(Buffer.getSize() == 0)
				{
					main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.BUFFER_EMPTY), AlertType.WARNING, 3000, main.dsp.getCurrent());
					return;
				}

				Vector group = AuxClass.enumerationToVector(ModuleRegistry.listSimilars(cgType.getString(cgType.getSelectedIndex())), null);

				FileConnection fc = (FileConnection)Connector.open("file:///" + filename);

				if(fc.exists())
				{
					fc.truncate(0);
				}
				else
				{
					fc.create();
				}

				OutputStreamEncoder ose = new OutputStreamEncoder(fc.openOutputStream(), StringEncoder.ENC_DEFAULT);

				ose.writeBOM();

				String disk = filename.substring(0, filename.indexOf('/'));
				String path = filename.substring(0, filename.lastIndexOf('/') + 1);

				int dlen = disk.length();
				int plen = path.length();

				Buffer.flattenBuffer();
				//Buffer.sortBuffer();

				Enumeration buf = Buffer.getBuffer();
				String s, module;
				int index;

				while(buf.hasMoreElements())
				{
					s = (String)buf.nextElement();

					index = s.lastIndexOf('.');

					if(index >= 0)
					{
						module = ModuleRegistry.getModule(s.substring(index + 1));

						if(module != null && group.contains(module))
						{
							if(s.startsWith(path))
							{
								ose.writeString(s.substring(plen).replace('/', '\\'));
							}
							else if(s.startsWith(disk))
							{
								ose.writeString(s.substring(dlen).replace('/', '\\'));
							}
							else
							{
								ose.writeString(s.replace('/', '\\'));
							}

							ose.writeChar('\r');
							ose.writeChar('\n');
						}
					}
				}

				ose.close();
				fc.close();

				Buffer.clear();

				main.FileSelect.showWait(filename.substring(filename.lastIndexOf('/') + 1));
			}
			catch(Exception e)
			{
				ErrScreen.showErrMsg(ModuleRegistry.getErrCode(getClass().getName()) * 100 + 1, e);
			}
		}
		else
		{
			main.dsp.setCurrent(parent);
		}
	}
}
