package modules.split;

import com.one.FileSource;
import com.one.file.Connector;
import com.one.file.FileConnection;
import com.vmx.AuxClass;
import com.vmx.Locale;
import filemanager.Buffer;
import filemanager.main;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.lcdui.AlertType;

public class FileSplicer implements FileSource
{
	public void createFile(String filename) throws IOException
	{
		if(Buffer.getSize() == 0)
		{
			main.showMessage(Locale.getString(this, Locale.ERROR), Locale.getString(this, Locale.BUFFER_EMPTY), AlertType.WARNING, 3000, main.dsp.getCurrent());
			return;
		}

		FileConnection target = (FileConnection)Connector.open("file:///" + filename);

		if(target.exists())
		{
			target.truncate(0);
		}
		else
		{
			target.create();
		}

		Buffer.flattenBuffer();
		//Buffer.sortBuffer();

		Enumeration files = Buffer.getBuffer();

		OutputStream os = target.openOutputStream();
		InputStream is;

		byte[] buf = new byte[AuxClass.COPYBUFSIZE];
		int len;

		while(files.hasMoreElements())
		{
			is = Connector.openInputStream("file:///" + files.nextElement());

			while((len = is.read(buf)) > 0)
			{
				os.write(buf, 0, len);
			}

			is.close();
		}

		os.close();
		target.close();

		Buffer.clear();

		main.FileSelect.showWait(filename.substring(filename.lastIndexOf('/') + 1));
	}
}
