package modules.split;

import com.one.Application;
import com.one.ErrScreen;
import com.one.ModuleRegistry;
import com.one.PlayList;
import com.one.file.Connector;
import com.one.file.FileConnection;
import com.vmx.AuxClass;
import com.vmx.Locale;
import filemanager.filesystem;
import filemanager.main;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;

public class FileSplitter implements Application, CommandListener, ItemStateListener
{
	public static final int PARTS_COUNT = 2, PART_SIZE = 3, SIZE_UNKNOWN = 4;

	protected Object parent;
	protected String filename;
	protected int filesize;

	protected TextField tfNumParts;
	protected TextField tfPartSize;

	public void openFile(String filename, PlayList filelist)
	{
		this.filename = filename;
		this.filesize = (int)filesystem.getSize(filename, false);

		if(filesize <= 0)
		{
			main.showMessage(Locale.getString(null, Locale.ERROR), Locale.getString(this, SIZE_UNKNOWN), AlertType.WARNING, 3000, null);
			return;
		}

		Form form = new Form(ModuleRegistry.getModuleName(getClass().getName()));

		tfNumParts = new TextField(Locale.getString(this, PARTS_COUNT), "1", 20, TextField.NUMERIC);
		tfPartSize = new TextField(Locale.getString(this, PART_SIZE), Integer.toString(filesize), 20, TextField.NUMERIC);

		form.append(tfNumParts);
		form.append(tfPartSize);

		form.addCommand(new Command(Locale.getString(null, Locale.OK_CMD), Command.OK, 1));
		form.addCommand(new Command(Locale.getString(null, Locale.CANCEL_CMD), Command.CANCEL, 2));
		form.setCommandListener(this);
		form.setItemStateListener(this);

		parent = main.dsp.getCurrent();
		main.dsp.setCurrent(form);
	}

	public void commandAction(Command c, Displayable dp)
	{
		if(c.getCommandType() == Command.OK)
		{
			try
			{
				InputStream is = Connector.openInputStream("file:///" + filename);

				FileConnection fc;
				OutputStream os;

				int partsize = Integer.parseInt(tfPartSize.getString());
				int total = 0;

				byte[] buf = new byte[Math.min(partsize, AuxClass.COPYBUFSIZE)];
				int len;

				int part = 1;
				int inpart;

				String name, ext;

				inpart = filename.lastIndexOf('.');

				if(inpart >= 0)
				{
					name = filename.substring(0, inpart);
					ext = filename.substring(inpart);
				}
				else
				{
					name = filename;
					ext = "";
				}

				while(total < filesize)
				{
					fc = (FileConnection)Connector.open("file:///" + name + "." + AuxClass.integerToString(part++, 2) + ext);

					if(fc.exists())
					{
						fc.truncate(0);
					}
					else
					{
						fc.create();
					}

					os = fc.openOutputStream();
					inpart = 0;

					partsize = Math.min(partsize, filesize - total);

					while(inpart < partsize)
					{
						len = is.read(buf);

						if(len <= 0)
						{
							break;
						}

						os.write(buf, 0, len);
						inpart += len;
					}

					os.close();
					fc.close();

					total += inpart;
				}

				is.close();

				main.FileSelect.showWait(filename.substring(filename.lastIndexOf('/') + 1));
			}
			catch(Exception e)
			{
				ErrScreen.showErrMsg(ModuleRegistry.getErrCode(getClass().getName()) * 100 + 1, e);
			}
		}
		else
		{
			main.dsp.setCurrent(parent);
		}
	}

	public void itemStateChanged(Item item)
	{
		if(item == tfNumParts)
		{
			int numparts = Integer.parseInt(tfNumParts.getString());

			if(numparts < 1)
			{
				numparts = 1;
			}
			else if(numparts > filesize)
			{
				numparts = filesize;
			}

			tfNumParts.setString(Integer.toString(numparts));
			tfPartSize.setString(Integer.toString((filesize + numparts - 1) / numparts));
		}
		else if(item == tfPartSize)
		{
			int partsize = Integer.parseInt(tfPartSize.getString());

			if(partsize < 1)
			{
				partsize = 1;
			}
			else if(partsize > filesize)
			{
				partsize = filesize;
			}

			tfNumParts.setString(Integer.toString((filesize + partsize - 1) / partsize));
			tfPartSize.setString(Integer.toString(partsize));
		}
	}
}
